<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;

class BackupDatabase extends Command
{
    protected $signature = 'backup:database';
    protected $description = 'Backup the database and store as SQL file';

    public function handle()
    {
        $db = config('database.connections.mysql.database');
        $user = config('database.connections.mysql.username');
        $pass = config('database.connections.mysql.password');
        $host = config('database.connections.mysql.host');

        $date = now()->format('Y-m-d');
        $file = storage_path("app/backups/backup-{$date}.sql");

        $command = "mysqldump -h {$host} -u {$user} -p\"{$pass}\" {$db} > {$file}";

        $returnVar = null;
        $output = null;

        exec($command, $output, $returnVar);

        if ($returnVar === 0) {
            $this->info("Database backup created: backup-{$date}.sql");
        } else {
            $this->error("Backup failed.");
        }
    }
}

