<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\classes\UserManager;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\CarHandover;

use Illuminate\Support\Facades\Response;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Storage;

    class CarHandoverController extends Controller
    {
        
    public function storeApi(Request $request)
    {
        $request->validate([
            'plate_number' => 'required|string|max:255',
            'model' => 'required|string|max:255',
            'type' => 'required|string|max:255',
            'brand' => 'required|string|max:255',
            'mileage' => 'required|string|max:255',
            'location' => 'required|string|max:255',
            'receiver_name' => 'required|string|max:255',
            'receiver_phone' => 'required|string|max:20',
            'receiver_id' => 'required|string|max:50',
            'supervisor_name' => 'required|string|max:255',
            'handover_date' => 'required|date',
            'handover_time' => 'required',
            'car_image' => 'required|image',
           
            'reason_for_no_delegation' => 'required_if:delegated,0|string|nullable',
            'delegation_number' => 'required_if:delegated,1|string|nullable',
            
            'vehicleContents' => 'required|string', 
            'otherContents' => 'required_if:vehicleContents,other|string'
        ]);
    
        $data = explode(',', $request->vehicleContents);
    
        // Check if 'other' is present
        if (in_array('other', $data)) {
           
            if (!$request->filled('otherContents')) {
                return response()->json([
                    'success' => false,
                    'message' => 'otherContents this field is required',
                ], 422);
            }
    
            // Append other contents to the data array
            $data[] = ['other'=>$request->otherContents];
        }
    
        $handover = new CarHandover();
        $handover->plate_number = $request->plate_number;
        $handover->model = $request->model;
        $handover->type = $request->type;
        $handover->brand = $request->brand;
        $handover->mileage = $request->mileage;
        $handover->location = $request->location;
        
        $handover->delegated = $request->delegated;
        $handover->reason_for_no_delegation = $request->reason_for_no_delegation;
        $handover->delegation_number = $request->delegation_number;
        
        $handover->vehicleContents = $data;
    
        $handover->receiver_name = $request->receiver_name;
        $handover->receiver_phone = $request->receiver_phone;
        $handover->receiver_id = $request->receiver_id;
        $handover->supervisor_name = $request->supervisor_name;
        $handover->handover_date = $request->handover_date;
        $handover->handover_time = $request->handover_time;
    
        if ($request->hasFile('car_image')) {
            $imageName = time() . '.' . $request->car_image->extension();
            $request->car_image->move(public_path('car_images'), $imageName);
            $handover->car_image = $imageName;
        }
    
        $handover->save();
    
        return response()->json([
            'success' => true,
            'message' => 'Car Handover Recorded Successfully!',
            'data' => $handover,
        ], 200);
    }

public function downloadPdfApi(Request $request)
{
    $handovers = CarHandover::all();

    $pdf = Pdf::loadView('CarHandover.pdf', compact('handovers'));

    // Define the filename and path
    $fileName = 'car_handover_report_list.pdf';
    $filePath = public_path('pdf/' . $fileName);

    // Create the folder if it doesn't exist
    if (!file_exists(public_path('pdf'))) {
        mkdir(public_path('pdf'), 0755, true);
    }

    // Save the PDF to the public/pdf directory
    file_put_contents($filePath, $pdf->output());

    // Return JSON with the public URL
    return response()->json([
        'success' => true,
        'message' => 'PDF generated successfully.',
        'url' => asset('pdf/' . $fileName)
    ], 200);
}
        
    }