<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\classes\UserManager;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\ManagerMonthlyReport;

use Illuminate\Support\Facades\Response;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Storage;

    class ManagerMonthlyReportController extends Controller
    {
          
     
    // public function MonthlyReportStore(Request $request)
    // {
    //     // First, validate the input manually for API
    //     $validator = Validator::make($request->all(), [
    //         'description' => 'required|string',
    //         'location' => 'required|string|max:255',
    //         'staff_entries' => 'required|array',
    //         'photo' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
    //     ]);
    
    //     // If validation fails, return errors in JSON
    //     if ($validator->fails()) {
    //         return response()->json([
    //             'status' => false,
    //             'message' => 'Validation Error',
    //             'errors' => $validator->errors()
    //         ], 422);
    //     }
    
    //     // Handle photo upload if exists
    //     $photoPath = null;
    //     if ($request->hasFile('photo')) {
    //         $photoPath = $request->file('photo')->store('manager_reports', 'public');
    //     }
    
    //     // Create the report
    //     $report = ManagerMonthlyReport::create([
    //         'description' => $request->input('description'),
    //         'location' => $request->input('location'),
    //         'staff_entries' => $request->input('staff_entries'), // should be casted to json in model
    //         'photo' => $photoPath,
    //     ]);
    
    //     // Return success response
    //     return response()->json([
    //         'status' => true,
    //         'message' => 'Manager Report created successfully!',
    //         'data' => $report
    //     ], 201);
    // }
    
public function MonthlyReportStore(Request $request)
{
    $request->validate([
        'description' => 'required|string',
        'location' => 'required|string|max:255',
        'staff_entries' => 'required',
        'photo' => 'required',
    ]);

    $photoPath = null;

    // Check if photo file is uploaded
    if ($request->hasFile('photo')) {
        $photoPath = $request->file('photo')->store('manager_reports', 'public');
    }

    // Decode JSON if staff_entries is passed as a string
    $staffEntries = $request->has('staff_entries') ? json_decode($request->input('staff_entries'), true) : [];

    $report = ManagerMonthlyReport::create([
        'description' => $request->input('description'),
        'location' => $request->input('location'),
        'staff_entries' => $staffEntries, // Store the decoded array
        'photo' => $photoPath,
    ]);

    return response()->json([
        'status' => true,
        'message' => 'Manager Report created successfully!',
        'data' => $report
    ], 201);
}


public function downloadPdfApi(Request $request)
{
    $monthlyReports = ManagerMonthlyReport::all();

    $pdf = Pdf::loadView('ManagerMonthlyReport.pdf', compact('monthlyReports'));

    // Define the filename and path
    $fileName = 'Monthly_Report_report_list.pdf';
    $filePath = public_path('pdf/' . $fileName);

    // Create the folder if it doesn't exist
    if (!file_exists(public_path('pdf'))) {
        mkdir(public_path('pdf'), 0755, true);
    }

    // Save the PDF to the public/pdf directory
    file_put_contents($filePath, $pdf->output());

    // Return JSON with the public URL
    return response()->json([
        'success' => true,
        'message' => 'PDF generated successfully.',
        'url' => asset('pdf/' . $fileName)
    ], 200);
}
        
    }