<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\classes\UserManager;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use App\Models\SupervisorWeeklyReport;

use Illuminate\Support\Facades\Response;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Storage;

    class SupervisorWeeklyReportController extends Controller
    {
        public function WeeklyReportStore(Request $request)
            {
            $request->validate([
                'description' => 'required|string',
                'location' => 'required|string|max:255',
                'staff_data' => 'required',
                'staff_entries' => 'required',
                'photo' => 'required',
            ]);
        
            $photoPath = null;
        
            // Check if photo file is uploaded
            if ($request->hasFile('photo')) {
                $photoPath = $request->file('photo')->store('manager_reports', 'public');
            }
            
            // Decode JSON if staff data is passed as a string
    $staff_data = $request->has('staff_data') ? json_decode($request->input('staff_data'), true) : [];
    
    // Decode JSON if staff_entries is passed as a string
    $staffEntries = $request->has('staff_entries') ? json_decode($request->input('staff_entries'), true) : [];
        
            $report = SupervisorWeeklyReport::create([
                'description' => $request->input('description'),
                'location' => $request->input('location'),
                'staff_data' => $staff_data,
                 'staff_entries' => $staffEntries,
                'photo' => $photoPath,
            ]);
    
            return response()->json([
                'success' => true,
                'message' => 'Report created successfully!',
                'data' => $report
            ], 201); // HTTP status code for created resource
        }
        
        
        public function downloadPdfApi(Request $request)
{
    $weeklyReports = SupervisorWeeklyReport::all();

    $pdf = Pdf::loadView('SupervisorWeeklyReport.pdf', compact('weeklyReports'));

    // Define the filename and path
    $fileName = 'Weekly_Report_report_list.pdf';
    $filePath = public_path('pdf/' . $fileName);

    // Create the folder if it doesn't exist
    if (!file_exists(public_path('pdf'))) {
        mkdir(public_path('pdf'), 0755, true);
    }

    // Save the PDF to the public/pdf directory
    file_put_contents($filePath, $pdf->output());

    // Return JSON with the public URL
    return response()->json([
        'success' => true,
        'message' => 'PDF generated successfully.',
        'url' => asset('pdf/' . $fileName)
    ], 200);
}
        
    }