<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\classes\UserManager;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

    class UserController extends Controller
    {
        public function user(Request $request)
        {
            $user = Auth::user();
            
            return response()->json(['status'=>true,'users'=>$user]);
        }
    
    
        public function showProfile(Request $request)
        {
            $user = Auth::user();
            
               if ($user->image) {
        $user->image = asset('profile_photos/' . $user->image);
    }
        
            return response()->json([
                'success' => true,
                'message' => 'User profile retrieved successfully.',
                'data' => $user,
            ], 200);
        }
     



       public function updateProfile(Request $request)
{
    $user = Auth::user();

    $validator = Validator::make($request->all(), [
        'name' => 'required|string|max:255',
        'mobile' => 'required|string',
        'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:20480', 
    ]);

    if ($validator->fails()) {
        return response()->json([
            'success' => false,
            'errors' => $validator->errors(),
        ], 422);
    }

    // Handle image upload if image is provided
    if ($request->hasFile('image')) {
        $image = $request->file('image');
        $imageName = time() . '_' . $image->getClientOriginalName();
        $image->move(public_path('profile_photos'), $imageName);

       // Delete old image if exists
        if ($user->image && file_exists(public_path('profile_photos/' . $user->image))) {
            unlink(public_path('profile_photos/' . $user->image));
        }

        $user->image = $imageName;
    }

    // Update user fields
    $user->name = $request->name;
    $user->mobile = $request->mobile;
    $user->save();

    return response()->json([
        'success' => true,
        'message' => 'User profile updated successfully.',
        'image_url' => $user->image ? asset('profile_photos/' . $user->image) : null,
    ], 200);
}

        
         
         public function updatePassword(Request $request)
    {
       
        $validated = $request->validate([
            'current_password' => 'required|string',
            'new_password' => 'required|string|min:8',
        ]);

       
        if (!Hash::check($validated['current_password'], Auth::user()->password)) {
            throw ValidationException::withMessages([
                'current_password' => ['The provided password does not match our records.'],
            ]);
        }

      
        Auth::user()->update([
            'password' => Hash::make($validated['new_password']),
        ]);

         return response()->json([
                'success' => true,
                'message' => 'User Password updated successfully.',
               
            ], 200);
    }
 



    
    }
