<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ManagerMonthlyReport;

use Barryvdh\DomPDF\Facade\Pdf;

class ManagerMonthlyReportController extends Controller
{
     public function index()
    {
        $monthlyReports = ManagerMonthlyReport::latest()->get();
        return view('ManagerMonthlyReport.index',compact('monthlyReports'));
    }
    
    
     public function create()
    {
        return view('ManagerMonthlyReport.create'); // your form page
    }
    
    public function store(Request $request)
    {
        $request->validate([
            'description' => 'required|string',
            'location' => 'required|string|max:255',
            'staff_entries' => 'required|array',
            'photo' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);
    
        $photoPath = null;
    
        // Check if photo file is uploaded
        if ($request->hasFile('photo')) {
            $photoPath = $request->file('photo')->store('manager_reports', 'public');
        }
    
        $report = ManagerMonthlyReport::create([
            'description' => $request->input('description'),
            'location' => $request->input('location'),
            'staff_entries' => $request->input('staff_entries'), // automatically cast to JSON
            'photo' => $photoPath,
        ]);
    
        return redirect()->back()->with('success', 'Manager Report created successfully!');
    }
    
        public function edit($id)
    {
        $report = ManagerMonthlyReport::findOrFail($id);
        return view('ManagerMonthlyReport.edit', compact('report'));
    }
    
    public function update(Request $request, $id)
    {
        $request->validate([
            'description' => 'nullable|string',
            'location' => 'required|string|max:255',
            'staff_entries' => 'nullable|array',
            'photo' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);
    
        $report = ManagerMonthlyReport::findOrFail($id);
    
        if ($request->hasFile('photo')) {
            $photoPath = $request->file('photo')->store('manager_reports', 'public');
            $report->photo = $photoPath;
        }
    
        $report->description = $request->input('description');
        $report->location = $request->input('location');
        $report->staff_entries = $request->input('staff_entries');
        $report->save();
    
        return redirect()->route('monthlyReport.List')->with('success', 'Report updated successfully!');
    }
    
    public function show($id)
    {
        $report = ManagerMonthlyReport::findOrFail($id);
        return view('ManagerMonthlyReport.show', compact('report'));
    }
    
    public function destroy($id)
    {
        ManagerMonthlyReport::destroy($id);
        return back()->with('success', 'Car handover deleted.');
    }
    
          public function downloadPdf()
    {
        $monthlyReports = ManagerMonthlyReport::all();
        $pdf = Pdf::loadView('ManagerMonthlyReport.pdf', compact('monthlyReports'));
        return $pdf->download('manager_monthly_report_list.pdf');
    }


}
