<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;

class RoleController extends Controller
{
    
    public function index()
    {
        $roles = Role::whereNot('name', 'Super Admin')->get(); // Exclude Super Admin
        return view('role.index', compact('roles'));
    }

    public function create()
    {
        $permissions = Permission::all();
        return view('role.create', compact('permissions'));
    }

       public function store(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255|unique:roles,name',
            'selected_permissions' => 'required|array|min:1',
        ]);
    
        $role = Role::create(['name' => $request->name, 'guard_name' => 'web']);
    
        
        $permissions = Permission::whereIn('id', $request->selected_permissions)->pluck('name')->toArray();
        
        $role->syncPermissions($permissions);
    
        return redirect()->route('role.list')->with('success', 'Role created successfully.');
    }


   public function edit(Role $role)
    {
        $permissions = Permission::all();
        $rolePermissions = $role->permissions->pluck('id')->toArray();
    
        return view('role.edit', compact('role', 'permissions', 'rolePermissions'));
    }


   public function update(Request $request, Role $role)
    {
        $request->validate([
            'name' => 'required|string|max:255|unique:roles,name,' . $role->id,
            'selected_permissions' => 'required|array|min:1',
        ]);
    
        $role->update(['name' => $request->name, 'guard_name' => 'web']);
    
        // Fetch permissions by ID and assign them
        $permissions = Permission::whereIn('id', $request->selected_permissions)->pluck('name')->toArray();
        
        $role->syncPermissions($permissions);
    
        return redirect()->route('role.list')->with('success', 'Role updated successfully.');
    }


    
    public function destroy(Role $role)
    {
        $role->delete();
        return redirect()->route('role.index')->with('success', 'Role deleted successfully.');
    }
}
