<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

 use App\Models\ManagerMonthlyReport;
use App\Models\SupervisorWeeklyVisit;
use App\Models\EventIncident;

class WelcomeController extends Controller
{


public function index()
{
    $monthlyVisits = ManagerMonthlyReport::whereMonth('created_at', now()->month)->count();
    $weeklyVisits = SupervisorWeeklyReport::whereBetween('created_at', [
        now()->startOfWeek(), now()->endOfWeek()
    ])->count();
    $incidentCount = EventIncident::whereMonth('created_at', now()->month)->count();

    $chartData = [
        'monthly' => $monthlyVisits,
        'weekly' => $weeklyVisits,
        'incidents' => $incidentCount,
    ];

   return view('welcome', compact('monthlyVisits', 'weeklyVisits', 'chartData'));

}


}
