<?php

namespace App\Listeners;

use Illuminate\Auth\Events\Login;
use Illuminate\Auth\Events\Logout;

class UpdateUserStatus
{
    /**
     * Handle user login event.
     */
    public function handleLogin(Login $event): void
    {
        $user = $event->user;
        $user->status = 1; // Set status to active on login
        $user->save();
    }

    /**
     * Handle user logout event.
     */
    public function handleLogout(Logout $event): void
    {
        $user = $event->user;

        if ($user) { // Check if user exists before updating
            $user->status = 0; // Set status to inactive on logout
            $user->save();
        }
    }
}
