<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('supervisor_weekly_reports', function (Blueprint $table) {
            $table->id();
            $table->text('description')->nullable();
            $table->string('location');
            $table->json('staff_entries')->nullable();
            $table->json('staff_data')->nullable(); 
            $table->string('photo')->nullable(); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('supervisor_weekly_reports');
    }
};
