<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\PermissionRegistrar;
use App\Models\User; // ✅ Import User model
use Illuminate\Support\Facades\Hash; // ✅ Import Hash

class RolesAndPermissionsSeeder extends Seeder
{
    public function run()
    {
        // Reset cached roles and permissions
        app()[PermissionRegistrar::class]->forgetCachedPermissions();

        // Define all permissions
        $permissions = [
            'roles-index',
            'roles-create',
            'roles-edit',
            'roles-delete',
            'users-index',
            'users-create',
            'users-edit',
            'users-delete',
            'colorbox-index',
            'colorbox-create',
            'colorbox-edit',
            'colorbox-delete',
            'colorbox-show',
            'parts-index',
            'parts-create',
            'parts-edit',
            'parts-delete',
            'parts-show',
            'sub-parts-index',
            'sub-parts-create',
            'sub-parts-edit',
            'sub-parts-delete',
            'sub-parts-show',
            
        ];

        // Create permissions if they don't exist
        foreach ($permissions as $permission) {
            Permission::firstOrCreate(['name' => $permission]);
        }

        // Create roles if they don't exist
        $roles = ['Super Admin', 'user'];
        foreach ($roles as $role) {
            Role::firstOrCreate(['name' => $role]);
        }

        // Assign all permissions to Super Admin
        $adminRole = Role::where('name', 'Super Admin')->first();
        if ($adminRole) {
            $adminRole->syncPermissions(Permission::all());
        }

        // Creating an admin user
        $admin = User::firstOrCreate(
            ['email' => 'admin@gmail.com'],
            [
                'role' => 'Super Admin',
                'name' => 'Hardik Savani',
                'password' => Hash::make('12345678'),
                'mobile' => '9090909090',
                'status' => true,
            ]
        );

        // Assign the Super Admin role
        if (!$admin->hasRole('Super Admin')) {
            $admin->assignRole('Super Admin');
        }

        // Creating a regular user
        $user = User::firstOrCreate(
            ['email' => 'user@gmail.com'],
            [
                'role' => 'user',
                'name' => 'Jane Doe',
                'password' => Hash::make('12345678'),
                'mobile' => '9090909091',
                'status' => true,
            ]
        );

        // Assign the "user" role
        if (!$user->hasRole('user')) {
            $user->assignRole('user');
        }
    }
}
