<!DOCTYPE html>
<html>
<head>
    <title>Car Handover List</title>
    <style>
        body { font-family: sans-serif; }
        table { width: 80%; border-collapse: collapse; font-size: 8px; }
        th, td { border: 1px solid #000; padding: 5px; text-align: left; }
          img { max-height: 60px; }
    </style>
</head>
<body>

<h2>Car Handover List</h2>

<table>
    <thead>
        <tr>
            <th>#</th>
            <th>Photo</th>
            <th>Plate Number</th>
            <th>Model</th>
            <th>Brand</th>
            <th>Mileage</th>
            <th>Location</th>
            <th>Delegated</th>
             <th>Delegation Info</th>
            <th>Receiver</th>
            <th>Supervisor</th>
            <th>Handover Date</th>
            <th>Handover Time</th>
              <th>Vehicle Contents</th>
        </tr>
    </thead>
    <tbody>
        @foreach($handovers as $key => $handover)
        <tr>
            <td>{{ $key + 1 }}</td>
            <td>
                @if($handover->car_image)
                    <img src="{{ public_path('car_images/' . $handover->car_image) }}" alt="Photo">
                @else
                    N/A
                @endif
            </td>
            <td>{{ $handover->plate_number }}</td>
            <td>{{ $handover->model }}</td>
            <td>{{ $handover->brand }}</td>
            <td>{{ $handover->mileage }}</td>
            <td>{{ $handover->location }}</td>
            <td>{{ $handover->delegated ? 'Yes' : 'No' }}</td>
            <td>
                @if($handover->delegated)
                 Delegation Number :  {{ $handover->delegation_number ?? 'N/A' }}
                @else
                   Reason For No Delegation : {{ $handover->reason_for_no_delegation ?? 'N/A' }}
                @endif
            </td>
            
            <td>{{ $handover->receiver_name }}</td>
            <td>{{ $handover->supervisor_name }}</td>
            <td>{{ \Carbon\Carbon::parse($handover->handover_date)->format('d M Y') }}</td>
            <td>{{ \Carbon\Carbon::parse($handover->handover_time)->format('h:i A') }}</td>
            <td>
                @php
                    $contents = is_string($handover->vehicleContents)
                        ? json_decode($handover->vehicleContents, true)
                        : $handover->vehicleContents;
                @endphp
            
                @if(is_array($contents))
                    <ul style="margin: 0; padding-left: 15px;">
                        @foreach($contents as $item)
                            <li>{{ is_array($item) ? json_encode($item) : $item }}</li>
                        @endforeach
                    </ul>
                @else
                    N/A
                @endif
            </td>



    
        </tr>
        @endforeach
    </tbody>
</table>

</body>
</html>
