@include('layouts.backend.header')

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                    <li class="nav-home">
                      <a href="{{route('dashboard')}}">
                       <i class="fa-solid fa-house"></i>
                      </a>
                    </li>
                    <li class="separator">
                     <i class="fa-solid fa-chevron-right"></i>
                    </li>
                <li class="nav-item">
                    <a href="#">Incident Report  </a>
                </li>
            </ul>
        </div>


        <div class="row">
            <div class="col-md-12">
                
                <div class="card">
                     <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Incident Report  List</h4>
                       <div>
                           <a href="{{ route('eventIncident.downloadPdf') }}" class="btn btn-dark">Download PDF</a> 
                           
                        <a href="{{ route('eventIncident.create') }}" class="btn btn-primary">+ Add Incident Report </a>
                       </div>
                    </div>
                      @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    
                    <div class="card-body">
                        <div class="table-responsive">
                          <table id="basic-datatables" class="display table table-primary table-hover">
                            <thead>
                                <tr>
                                <th>#</th>
                                <th>Photo</th>
                                <th>Guard Name</th>
                                <th>Shift</th>
                                <th>Location</th>
                                <th>Date</th>
                                <th>Reporting Time</th>
                                <th>Report Details</th>
                                <th>Action Taken</th>
                                <th>Reporting Person</th>
                                <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($incidents as $key => $incident)
                                    <tr>
                                        <td>{{ $key + 1 }}</td>
                                       
                                        <td>
                                            @if($incident->photo)
                                                <img src="{{ asset('incident_photos/' . $incident->photo) }}" alt="Photo" width="50" class="rounded-circle">
                                            @else
                                                <span class="text-muted">N/A</span>
                                            @endif
                                        </td>
                                        <td>{{ $incident->guard_name }}</td>
                                        <td>{{ $incident->shift }}</td>
                                        <td>{{ $incident->location }}</td>
                                        <td>{{ \Carbon\Carbon::parse($incident->date)->format('d M, Y') }}</td>
                                        <td>{{ \Carbon\Carbon::parse($incident->reporting_time)->format('h:i A') }}</td>
                                        <td>{{ Str::limit($incident->report_details, 40) ?? 'N/A' }}</td>
                                        <td>{{ Str::limit($incident->action_taken, 40) ?? 'N/A' }}</td>
                                        <td>{{ $incident->reporting_person ?? 'N/A' }}</td>
                                        <td>
                                           <a href="{{ route('eventIncident.edit', $incident->id) }}" class="btn btn-warning btn-sm">Edit</a>
                                            <a href="{{ route('eventIncident.show', $incident->id) }}" class="btn btn-warning btn-sm">show</a>
                                            
                                            <form action="{{ route('eventIncident.destroy', $incident->id) }}" method="POST" style="display:inline-block;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                            </form>

                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('layouts.backend.footer')
