<!DOCTYPE html>
<html>
<head>
    <title>Incident Report List</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 12px; }
        table { width: 100%; border-collapse: collapse; }
        th, td { border: 1px solid #999; padding: 5px; text-align: left; }
        th { background-color: #eee; }
        img { max-height: 60px; }
    </style>
</head>
<body>
    <h2>All Event Incident Reports</h2>
    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Photo</th>
                <th>Guard Name</th>
                <th>Shift</th>
                <th>Location</th>
                <th>Date</th>
                <th>Reporting Time</th>
                <th>Report Details</th>
                <th>Action Taken</th>
                <th>Reporting Person</th>
            </tr>
        </thead>
        <tbody>
            @foreach($incidents as $key => $incident)
                <tr>
                    <td>{{ $key + 1 }}</td>
                    <td>
                        @if($incident->photo)
                            <img src="{{ public_path('incident_photos/' . $incident->photo) }}" alt="Photo">
                        @else
                            N/A
                        @endif
                    </td>
                    <td>{{ $incident->guard_name }}</td>
                    <td>{{ $incident->shift }}</td>
                    <td>{{ $incident->location }}</td>
                    <td>{{ \Carbon\Carbon::parse($incident->date)->format('d M, Y') }}</td>
                    <td>{{ \Carbon\Carbon::parse($incident->reporting_time)->format('h:i A') }}</td>
                    <td>{{ $incident->report_details }}</td>
                    <td>{{ $incident->action_taken }}</td>
                    <td>{{ $incident->reporting_person }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>
