@include('layouts.backend.header')
<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="{{ route('dashboard') }}">
                        <i class="fa-solid fa-house"></i>
                    </a>
                </li>
                <li class="separator"><i class="fa-solid fa-chevron-right"></i></li>
                <li class="nav-item"><a href="#">Incident Details</a></li>
            </ul>
        </div>

        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h4 class="card-title">Incident Report Details</h4>
                <a href="{{ route('eventIncident.List') }}" class="btn btn-primary">Back to List</a>
            </div>
            <div class="card-body">
                <p><strong>Guard Name:</strong> {{ $incident->guard_name }}</p>
                <p><strong>Shift:</strong> {{ $incident->shift }}</p>
                <p><strong>Location:</strong> {{ $incident->location }}</p>
                <p><strong>Date:</strong> {{ $incident->date }}</p>
                <p><strong>Reporting Time:</strong> {{ $incident->reporting_time }}</p>
                <p><strong>Report Details:</strong> {{ $incident->report_details }}</p>
                <p><strong>Action Taken:</strong> {{ $incident->action_taken }}</p>
                <p><strong>Reporting Person:</strong> {{ $incident->reporting_person }}</p>
                
                @if($incident->photo)
                    <p><strong>Photo Evidence:</strong></p>
                    <img src="{{ asset('incident_photos/' . $incident->photo) }}" alt="Photo Evidence" style="max-width: 100px;">
                @endif
            </div>
        </div>
    </div>
</div>
@include('layouts.backend.footer')
