@include('layouts.backend.header')

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="{{ route('dashboard') }}">
                        <i class="bi bi-house-door-fill"></i>
                    </a>
                </li>
                <li class="separator"><i class="bi bi-chevron-right"></i></li>
                <li class="nav-item">Edit Staff Evaluation</li>
            </ul>
        </div>

        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h4 class="card-title">Edit Staff Evaluation</h4>
                <a href="{{ route('monthlyReport.List') }}" class="btn btn-primary">Back to List</a>
            </div>

            <div class="card-body">
                <form action="{{ route('monthlyReport.update', $report->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div id="staff-entries-container">
                        @foreach($report->staff_entries ?? [] as $i => $entry)
                        <div class="form-section border rounded p-3 mb-3 position-relative bg-light">
                            <button type="button" class="btn-close position-absolute top-0 end-0 me-2 mt-2" onclick="this.closest('.form-section').remove()"></button>
                            <h6 class="mb-3">Staff Entry #{{ $i + 1 }}</h6>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Staff Name</label>
                                    <input type="text" name="staff_entries[{{ $i }}][name]" value="{{ $entry['name'] ?? '' }}" class="form-control">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Shift</label>
                                    <input type="text" name="staff_entries[{{ $i }}][shift]" value="{{ $entry['shift'] ?? '' }}" class="form-control">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Attendance</label>
                                    <select name="staff_entries[{{ $i }}][attendance]" class="form-select">
                                        @foreach(['Excellent', 'Good', 'Average', 'Poor'] as $val)
                                            <option {{ ($entry['attendance'] ?? '') == $val ? 'selected' : '' }}>{{ $val }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Duties</label>
                                    <select name="staff_entries[{{ $i }}][duties]" class="form-select">
                                        @foreach(['Excellent', 'Good', 'Average', 'Poor'] as $val)
                                            <option {{ ($entry['duties'] ?? '') == $val ? 'selected' : '' }}>{{ $val }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Uniform</label>
                                    <select name="staff_entries[{{ $i }}][uniform]" class="form-select">
                                        @foreach(['Excellent', 'Good', 'Average', 'Poor'] as $val)
                                            <option {{ ($entry['uniform'] ?? '') == $val ? 'selected' : '' }}>{{ $val }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Presence</label>
                                    <select name="staff_entries[{{ $i }}][presence]" class="form-select">
                                        @foreach(['Excellent', 'Good', 'Average', 'Poor'] as $val)
                                            <option {{ ($entry['presence'] ?? '') == $val ? 'selected' : '' }}>{{ $val }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>

                    <button type="button" class="btn btn-outline-primary btn-sm mb-3" id="add-entry-btn">
                        <i class="bi bi-plus-circle"></i> Add Staff Entry
                    </button>

                    <div class="form-section mb-4">
                        <label class="form-label fw-semibold">Report Details</label>
                        <textarea class="form-control" name="description" rows="4">{{ $report->description }}</textarea>
                    </div>

                    <div class="form-section mb-4">
                        <label class="form-label fw-semibold">Photo Evidence</label>
                        <input type="file" name="photo" accept="image/*" class="form-control">
                        @if ($report->photo)
                            <img src="{{ asset('storage/' . $report->photo) }}" class="mt-2" width="100">
                        @endif
                    </div>

                    <div class="form-section mb-4">
                        <label class="form-label fw-semibold">Location <span class="text-danger">*</span></label>
                        <input type="text" name="location" value="{{ $report->location }}" class="form-control" required>
                    </div>

                    <div class="d-flex justify-content-end mt-3">
                        <button type="submit" class="btn btn-success">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    let staffEntryCount = {{ count($report->staff_entries ?? []) }};

    document.getElementById("add-entry-btn").addEventListener("click", function () {
        staffEntryCount++;
        const entryHTML = `
        <div class="form-section border rounded p-3 mb-3 position-relative bg-light">
            <button type="button" class="btn-close position-absolute top-0 end-0 me-2 mt-2" onclick="this.closest('.form-section').remove()"></button>
            <h6 class="mb-3">Staff Entry #${staffEntryCount}</h6>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Staff Name</label>
                    <input type="text" name="staff_entries[${staffEntryCount}][name]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Shift</label>
                    <input type="text" name="staff_entries[${staffEntryCount}][shift]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Attendance</label>
                    <select name="staff_entries[${staffEntryCount}][attendance]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Duties</label>
                    <select name="staff_entries[${staffEntryCount}][duties]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Uniform</label>
                    <select name="staff_entries[${staffEntryCount}][uniform]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Presence</label>
                    <select name="staff_entries[${staffEntryCount}][presence]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
            </div>
        </div>
        `;
        document.getElementById("staff-entries-container").insertAdjacentHTML("beforeend", entryHTML);
    });
</script>

@include('layouts.backend.footer')
