@include('layouts.backend.header')

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="{{ route('dashboard') }}">
                        <i class="fa-solid fa-house"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="fa-solid fa-chevron-right"></i>
                </li>
                <li class="nav-item">
                    <a href="#">Weekly  Report</a>
                </li>
            </ul>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title"> Weekly Report</h4>
                         <div>
                            <a href="{{ route('weeklyReport.downloadPdf') }}" class="btn btn-dark">Download PDF</a> 
                            
                            <a href="{{ route('weeklyReport.create') }}" class="btn btn-primary">+ Add </a>
                          </div>
                    </div>

                    @if (session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif

                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="basic-datatables" class="display table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        
                                        <th>Date & Time </th>
                                        <th>Photo</th>
                                        <th>Location</th>
                                        <th>Description</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($weeklyReports as $index => $report)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            
                                            <td>{{ $report->created_at->format('d M Y, h:i A') }}</td>


                                            <td>
                                                @if($report->photo)
                                                    <img src="{{ asset('storage/' . $report->photo) }}" width="60" height="60" class="rounded shadow-sm" />
                                                @else
                                                    <span class="text-muted">No Photo</span>
                                                @endif
                                            </td>

                                            <td>{{ $report->location }}</td>
                                            <td>{{ Str::limit($report->description, 40) ?? 'N/A' }}</td>
                                           
                                            <td>
                                                <a href="{{ route('weeklyReport.show', $report->id) }}" class="btn btn-info btn-sm">Show</a>
                                                <a href="{{ route('weeklyReport.edit', $report->id) }}" class="btn btn-warning btn-sm">Edit</a>
                                                <form action="{{ route('weeklyReport.destroy', $report->id) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                                </form>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>  
</div>

@include('layouts.backend.footer')
