@include('layouts.backend.header')

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="{{ route('dashboard') }}">
                        <i class="bi bi-house-door-fill"></i>
                    </a>
                </li>
                <li class="separator"><i class="bi bi-chevron-right"></i></li>
                <li class="nav-item">Staff Evaluation Report</li>
            </ul>
        </div>

        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h4 class="card-title">Staff Evaluation Details</h4>
                <a href="{{ route('monthlyReport.List') }}" class="btn btn-primary">Back to List</a>
            </div>

            <div class="card-body">
                <div class="mb-3">
                    <label class="fw-semibold">Location:</label>
                    <div>{{ $report->location }}</div>
                </div>

                <div class="mb-3">
                    <label class="fw-semibold">Description:</label>
                    <div>{{ $report->description ?? '-' }}</div>
                </div>

                @if($report->photo)
                    <div class="mb-3">
                        <label class="fw-semibold">Photo Evidence:</label><br>
                        <img src="{{ asset('storage/' . $report->photo) }}" class="img-thumbnail" style="max-height: 200px; max-width: 200px;">
                    </div>
                @endif

                @php
                    $staffEntries = $report->staff_entries ?? [];
                @endphp
                
                @if (!empty($staffEntries))
                    <div class="table-responsive mt-4">
                        <h5 class="fw-bold">Staff Assessment:</h5>
                        <div class="table-responsive">
                            <table id="basic-datatables" class="display table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>Staff Name</th>
                                    <th>Shift</th>
                                    <th>Attendance</th>
                                    <th>Duties</th>
                                    <th>Uniform</th>
                                    <th>Presence</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($staffEntries as $entry)
                                    <tr>
                                        <td>{{ $entry['name'] ?? '-' }}</td>
                                        <td>{{ $entry['shift'] ?? '-' }}</td>
                                        <td>{{ $entry['attendance'] ?? '-' }}</td>
                                        <td>{{ $entry['duties'] ?? '-' }}</td>
                                        <td>{{ $entry['uniform'] ?? '-' }}</td>
                                        <td>{{ $entry['presence'] ?? '-' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        </div>
                    </div>
                @else
                    <p class="text-muted">No staff entries available.</p>
                @endif
                <hr>
                 @php
                    $staffData = $report->staff_data ?? [];
                @endphp
                
                @if (!empty($staffData))
                    <div class="table-responsive mt-4">
                        <h5 class="fw-bold">Staff Evaluation:</h5>
                        <div class="table-responsive">
                            <table id="basic-datatables" class="display table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>Staff Name</th>
                                    <th>Shift</th>
                                    <th>Attendance</th>
                                    <th>Duties</th>
                                    <th>Uniform</th>
                                    <th>Presence</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($staffData as $entry)
                                    <tr>
                                        <td>{{ $entry['name'] ?? '-' }}</td>
                                        <td>{{ $entry['shift'] ?? '-' }}</td>
                                        <td>{{ $entry['attendance'] ?? '-' }}</td>
                                        <td>{{ $entry['duties'] ?? '-' }}</td>
                                        <td>{{ $entry['uniform'] ?? '-' }}</td>
                                        <td>{{ $entry['presence'] ?? '-' }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        </div>
                    </div>
                @else
                    <p class="text-muted">No staff entries available.</p>
                @endif
                
            </div>
        </div>
    </div>
</div>

@include('layouts.backend.footer')
