<!DOCTYPE html>
<html lang="en">
  <head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>Admin Dashboard</title>
    <meta
      content="width=device-width, initial-scale=1.0, shrink-to-fit=no"
      name="viewport"
    />
    <link
      rel="icon"
      href="{{asset('logos/fiv.png')}}"
      type="image/x-icon"
    />

    <!-- Fonts and icons -->
     <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
    <script src="{{asset('backend/assets/js/plugin/webfont/webfont.min.js')}}"></script>
    <script>
      WebFont.load({
        google: { families: ["Public Sans:300,400,500,600,700"] },
        custom: {
          families: [
            "Font Awesome 5 Solid",
            "Font Awesome 5 Regular",
            "Font Awesome 5 Brands",
            "simple-line-icons",
          ],
          urls: ["{{asset('assets/css/fonts.min.css')}}"],
        },
        active: function () {
          sessionStorage.fonts = true;
        },
      });
    </script>

    <!-- CSS Files -->
    <link rel="stylesheet" href="{{asset('backend/assets/css/bootstrap.min.css')}}" />
    <link rel="stylesheet" href="{{asset('backend/assets/css/plugins.min.css')}}" />
    <link rel="stylesheet" href="{{asset('backend/assets/css/kaiadmin.min.css')}}" />

    <!-- CSS Just for demo purpose, don't include it in your project -->
    <link rel="stylesheet" href="{{asset('backend/assets/css/demo.css')}}" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.6.0/css/all.min.css" integrity="sha512-Kc323vGBEqzTmouAECnVceyQqyqdsSiqLQISBL29aUW4U/M7pSPA/gEUZQqv1cwx4OnYxTxve5UMg5GT6L4JJg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <style>
      .col-10.col-xs-11.col-sm-4.alert.alert-secondary{
        display: none !important;
      }
    </style>
  </head>
  <body>
    <div class="wrapper">
      <!-- Sidebar -->
      <div class="sidebar" data-background-color="dark">
        <div class="sidebar-logo">
          <!-- Logo Header -->
          <div class="logo-header" data-background-color="dark">
            <a href="{{route('dashboard')}}" class=" logo  text-light">
              <img
                src="{{asset('logos/logo.png')}}"
                alt="navbar brand"
                class="navbar-brand"
                height="60"
              />
            
            </a>
            <div class="nav-toggle">
              <button class="btn btn-toggle toggle-sidebar">
                <i class="gg-menu-right"></i>
              </button>
              <button class="btn btn-toggle sidenav-toggler">
                <i class="gg-menu-left"></i>
              </button>
            </div>
            <button class="topbar-toggler more">
              <i class="gg-more-vertical-alt"></i>
            </button>
          </div>
          <!-- End Logo Header -->
        </div>
        <div class="sidebar-wrapper scrollbar scrollbar-inner">
          <div class="sidebar-content">
            <ul class="nav nav-secondary">
              <li class="nav-item active">
                <a
                  
                  href="{{route('dashboard')}}"
                  class="collapsed"
                 
                >
                  <i class="fas fa-home"></i>
                  <p>Dashboard</p>
                 
                </a>
              </li>
              <li class="nav-section">
                <span class="sidebar-mini-icon">
                  <i class="fa fa-ellipsis-h"></i>
                </span>
                <h4 class="text-section">Components</h4>
              </li>
             
              
              @can('roles-index')
              <li class="nav-item">
                <a href="{{ route('role.list') }}">
                <i class="fa-brands fa-slack"></i>
                  <p>Role & Permission</p>
                </a>
              </li> @endcan
              
              @can('users-index')
              <li class="nav-item">
                <a href="{{ route('user.list') }}">
                <i class="fa-regular fa-user"></i>
                  <p>Staff</p>
                </a>
              </li> @endcan
              
              
              <!-- <li class="nav-item">-->
              <!--  <a data-bs-toggle="collapse" href="#base">-->
              <!--    <i class="fas fa-layer-group"></i>-->
              <!--    <p>Report </p>-->
              <!--    <span class="caret"></span>-->
              <!--  </a>-->
              <!--  <div class="collapse" id="base">-->
              <!--    <ul class="nav nav-collapse">-->
              <!--      <li>-->
              <!--        <a href="{{route('eventIncident.List')}}">-->
              <!--          <span class="sub-item">Event Incident </span>-->
              <!--        </a>-->
              <!--      </li>-->
                  
              <!--    </ul>-->
              <!--  </div>-->
              <!--</li>-->
              
               <li class="nav-item">
                <a href="{{route('eventIncident.List')}}">
                <i class="fas fa-layer-group"></i>
                  <p>Event Incident</p>
                </a>
              </li>
              
              <li class="nav-item">
                <a href="{{ route('handover.List') }}">
                <i class="bi bi-car-front"></i>
                  <p>Car Handover</p>
                </a>
              </li>
              
                <li class="nav-item">
                <a href="{{ route('monthlyReport.List') }}">
                <i class="fas fa-layer-group"></i>
                  <p>Manager Monthly Report</p>
                </a>
              </li>
              
                <li class="nav-item">
                <a href="{{ route('weeklyReport.List') }}">
                <i class="fas fa-layer-group"></i>
                  <p>Supervisor Weekly Report</p>
                </a>
              </li>
              
             
              
              
             
              
          
            </ul>
          </div>
        </div>
      </div>
      <!-- End Sidebar -->

      <div class="main-panel">
        <div class="main-header">
          <div class="main-header-logo">
            <!-- Logo Header -->
            <div class="logo-header" data-background-color="dark">
              <a href="{{route('dashboard')}}" class="logo">
                <img
                  src="{{asset('logos/logo.png')}}"
                  alt="navbar brand"
                  class="navbar-brand"
                  height="20"
                />
              </a>
              <div class="nav-toggle">
                <button class="btn btn-toggle toggle-sidebar">
                  <i class="gg-menu-right"></i>
                </button>
                <button class="btn btn-toggle sidenav-toggler">
                  <i class="gg-menu-left"></i>
                </button>
              </div>
              <button class="topbar-toggler more">
                <i class="gg-more-vertical-alt"></i>
              </button>
            </div>
            <!-- End Logo Header -->
          </div>
          <!-- Navbar Header -->
          <nav
            class="navbar navbar-header navbar-header-transparent navbar-expand-lg border-bottom"
          >
            <div class="container-fluid">
              <nav
                class="navbar navbar-header-left navbar-expand-lg navbar-form nav-search p-0 d-none d-lg-flex"
              >
                <div class="input-group">
                 
                  
                  <a href="{{route('home')}}" class="btn btn-outline-primary">
                      Dashboard
                  </a>
                </div>
              </nav>

              <ul class="navbar-nav topbar-nav ms-md-auto align-items-center">
                <li
                  class="nav-item topbar-icon dropdown hidden-caret d-flex d-lg-none"
                >
                  <a
                    class="nav-link dropdown-toggle"
                    data-bs-toggle="dropdown"
                    href="#"
                    role="button"
                    aria-expanded="false"
                    aria-haspopup="true"
                  >
                    <i class="fa fa-search"></i>
                  </a>
                  <ul class="dropdown-menu dropdown-search animated fadeIn">
                    <form class="navbar-left navbar-form nav-search">
                      <div class="input-group">
                        <input
                          type="text"
                          placeholder="Search ..."
                          class="form-control"
                        />
                      </div>
                    </form>
                  </ul>
                </li>
              

                <li class="nav-item topbar-user dropdown hidden-caret">
                  <a
                    class="dropdown-toggle profile-pic"
                    data-bs-toggle="dropdown"
                    href="#"
                    aria-expanded="false"
                  >
                    <div class="avatar-sm">
                     
                      
                      @if(auth()->user()->image)
                        <img src="{{ asset('profile_photos/' . auth()->user()->image) }}" alt="Profile Photo"  class="avatar-img rounded-circle">
                    @else
                        <p>No Profile Photo</p>
                    @endif
                    </div>
                    <span class="profile-username">
                      <span class="op-7">Hi,</span>
                      <span class="fw-bold">{{ Auth::user()->name }}</span>
                    </span>
                  </a>
                  <ul class="dropdown-menu dropdown-user animated fadeIn">
                    <div class="dropdown-user-scroll scrollbar-outer">
                      
                      <li>
                       
                        <a class="dropdown-item" href="#">
                        <x-dropdown-link :href="route('profile.edit')">
                            {{ __('Profile') }}
                        </x-dropdown-link>
                        </a>
                        <a class="dropdown-item" href="#">
                           <form method="POST" action="{{ route('logout') }}">
                            @csrf

                            <x-dropdown-link :href="route('logout')"
                                    onclick="event.preventDefault();
                                                this.closest('form').submit();">
                                {{ __('Log Out') }}
                            </x-dropdown-link>
                        </form></a>
                      </li>
                    </div>
                  </ul>
                </li>
              </ul>
            </div>
          </nav>
          <!-- End Navbar -->
        </div>