@include('layouts.backend.header')

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                     <li class="nav-home">
          <a href="{{route('dashboard')}}">
           <i class="fa-solid fa-house"></i>
          </a>
        </li>
        <li class="separator">
         <i class="fa-solid fa-chevron-right"></i>
        </li>
                <li class="nav-item">
                    <a href="#">Edit Role</a>
                </li>
            </ul>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Edit Role</h4>
                        <a href="{{ route('role.list') }}" class="btn btn-secondary">Back to List </a>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('role.update', $role->id) }}" method="POST">
                            @csrf
                            @method('PUT')

                            <div class="mb-3">
                                <label for="name" class="form-label">Role Name</label>
                                <input type="text" name="name" id="name" class="form-control" value="{{ old('name', $role->name) }}" required>
                            </div>

                            <div class="mb-3">
                                <label for="permissions" class="form-label">Permissions</label>
                                <div id="permissions" class="row">
                                    @foreach ($permissions as $permission)
                                        <div class="col-md-3">
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" name="selected_permissions[]" value="{{ $permission->id }}" id="permission{{ $permission->id }}"
                                                    {{ in_array($permission->id, $rolePermissions) ? 'checked' : '' }}>
                                                <label class="form-check-label" for="permission{{ $permission->id }}">
                                                    {{ $permission->name }}
                                                </label>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                                @error('selected_permissions') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>

                            <button type="submit" class="btn btn-primary">Update Role</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('layouts.backend.footer')
