@include('layouts.backend.header')

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
          <a href="{{route('dashboard')}}">
           <i class="fa-solid fa-house"></i>
          </a>
        </li>
        <li class="separator">
         <i class="fa-solid fa-chevron-right"></i>
        </li>
                <li class="nav-item">
                    <a href="#">Role </a>
                </li>
            </ul>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Role List</h4>
                       @can('roles-create') <a href="{{ route('role.create') }}" class="btn btn-primary">+ Add role</a>@endcan
                    </div>
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="basic-datatables" class="display table table-primary table-hover">
                                <thead>
                                    <tr>
                                        <th>Role</th>
                                        <th>Permissions</th>
                                       
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($roles as $role)
                                        <tr>
                                            <td>{{ $role->name }}</td>
                                             <td class="text-center">
                                                @foreach ($role->permissions as $permission)
                                                    <span>{{ $permission->name }}</span>
                                                    @if (!$loop->last)
                                                        <span>, </span>
                                                    @endif
                                                @endforeach
                                            </td>
                                            
                                            <td>
                                                @can('roles-edit')<a href="{{ route('role.edit', $role->id) }}" class="btn btn-warning">
                                                    <i class="fa-solid fa-pen-to-square"></i> Edit
                                                </a>@endcan
                                               @can('roles-delete') <form action="{{ route('role.delete', $role->id) }}" method="POST" style="display:inline;">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-danger">
                                                        <i class="fa-solid fa-trash"></i> 
                                                    </button>
                                                </form>@endcan

                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('layouts.backend.footer')
