@include('layouts.backend.header')

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                    <li class="nav-home">
                      <a href="{{route('dashboard')}}">
                       <i class="fa-solid fa-house"></i>
                      </a>
                    </li>
                    <li class="separator">
                     <i class="fa-solid fa-chevron-right"></i>
                    </li>
                <li class="nav-item">
                    <a href="#">User Management </a>
                </li>
            </ul>
        </div>


        <div class="row">
            <div class="col-md-12">
                
                <div class="card">
                     <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">User List</h4>
                       @can('users-create') <a href="{{ route('user.create') }}" class="btn btn-primary">+ Add User</a>@endcan
                    </div>
                      @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    
                    <div class="card-body">
                        <div class="table-responsive">
                          <table id="basic-datatables" class="display table table-primary table-hover">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Profile Photo</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Role</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($users as $key => $user)
                                    <tr>
                                        <td>{{ $key + 1 }}</td>
                                        <td> <img src="{{ asset('public/profile_photos/' . $user->image) }}" alt="Profile Photo" width="50" class="rounded-circle"></td>
                                        <td>{{ $user->name }}</td>
                                        <td>{{ $user->email }}</td>
                                        <td>{{ $user->roles->first()->name ?? 'N/A' }}</td>
                                        <td>
                                          @can('users-edit')  <a href="{{ route('user.edit', $user->id) }}" class="btn btn-warning btn-sm">Edit</a>@endcan
                                            
                                            @can('users-delete') <form action="{{ route('user.delete', $user->id) }}" method="POST" style="display:inline-block;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                            </form>@endcan
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@include('layouts.backend.footer')
