<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\CarHandoverController;
use App\Http\Controllers\Api\EventIncidentController;
use App\Http\Controllers\Api\ManagerMonthlyReportController;
use App\Http\Controllers\Api\SupervisorWeeklyReportController;
use App\Http\Controllers\Api\SignUpApiController;

use App\Models\ManagerMonthlyReport;
use App\Models\SupervisorWeeklyReport;
use App\Models\EventIncident;



    
    Route::post('login',[AuthController::class,'Login']);
     
    Route::post('register', [AuthController::class, 'register']);
    
    Route::post('forgotPassword', [AuthController::class, 'forgotPassword']);
    Route::post('verifyOtp', [AuthController::class, 'verifyOtp']);





    Route::post('/signup', [SignUpApiController::class, 'signup']);
    Route::post('/verify-otp', [SignUpApiController::class, 'verifyOtp']);





Route::middleware('auth:sanctum')->group(function () {
    
    Route::get('get-profile', [UserController::class, 'showProfile']);
    
    Route::post('update-profile', [UserController::class, 'updateProfile']);
   
    Route::post('update-password', [UserController::class, 'updatePassword']);
    
    Route::post('logout',[AuthController::class,'Logout']);

    Route::group(['prefix'=>'user'], function(){
        Route::get('/',[UserController::class,'user']);
       
    });
    
    

    Route::post('car-handover', [CarHandoverController::class, 'storeApi']);
     Route::get('carHandovers/download-pdf', [CarHandoverController::class, 'downloadPdfApi']);
    
    Route::post('event-incident', [EventIncidentController::class, 'eventIncidentStore']);
    Route::get('event-incidents/download-pdf', [EventIncidentController::class, 'downloadPdfApi']);

    
    Route::post('monthly-report', [ManagerMonthlyReportController::class, 'MonthlyReportStore']);
     Route::get('monthlyReports/download-pdf', [ManagerMonthlyReportController::class, 'downloadPdfApi']);
    
    Route::post('weekly-report', [SupervisorWeeklyReportController::class, 'WeeklyReportStore']);
     Route::get('weeklyReports/download-pdf', [SupervisorWeeklyReportController::class, 'downloadPdfApi']);

    


    Route::get('dashboard-summary', function () {
        $monthly = ManagerMonthlyReport::whereMonth('created_at', now()->month)->count();
        $weekly = SupervisorWeeklyReport::whereBetween('created_at', [now()->startOfWeek(), now()->endOfWeek()])->count();
        $incidents = EventIncident::whereMonth('created_at', now()->month)->count();
    
        return response()->json([
            'monthly' => $monthly,
            'weekly' => $weekly,
            'incidents' => $incidents,
        ]);
    });


    
    
});