<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;


use App\Http\Controllers\WelcomeController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ReportsArchive;

use App\Http\Controllers\EventIncidentController;
use App\Http\Controllers\CarHandoverController;
use App\Http\Controllers\ManagerMonthlyReportController;
use App\Http\Controllers\SupervisorWeeklyReportController;

    
use App\Models\ManagerMonthlyReport;
use App\Models\SupervisorWeeklyReport;
use App\Models\EventIncident;

use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Storage;
use Illuminate\Http\Request;

Route::get('/download-backup', function (Request $request) {
    $date = $request->query('date');

    $db = config('database.connections.mysql.database');
    $user = config('database.connections.mysql.username');
    $pass = config('database.connections.mysql.password');
    $host = config('database.connections.mysql.host');

    $file = storage_path("app/backups/backup-{$date}.sql");

    if (!file_exists($file)) {
        // Create backup dynamically
        $command = "mysqldump -h {$host} -u {$user} -p\"{$pass}\" {$db} > {$file}";
        exec($command, $output, $returnVar);

        if ($returnVar !== 0 || !file_exists($file)) {
            abort(404, 'Backup could not be created or found.');
        }
    }

    return response()->download($file);
});





Route::group(['prefix' => 'monthlyReports', 'as' => 'monthlyReport.'], function () {
    Route::get('list', [ManagerMonthlyReportController::class, 'index'])->name('List'); 
    Route::get('create', [ManagerMonthlyReportController::class, 'create'])->name('create'); 
    Route::post('store', [ManagerMonthlyReportController::class, 'store'])->name('store');
    Route::get('show/{id}', [ManagerMonthlyReportController::class, 'show'])->name('show');
    Route::get('edit/{id}', [ManagerMonthlyReportController::class, 'edit'])->name('edit'); 
    Route::put('update/{id}', [ManagerMonthlyReportController::class, 'update'])->name('update'); 
    Route::delete('delete/{id}', [ManagerMonthlyReportController::class, 'destroy'])->name('destroy'); 
    
      Route::get('download-pdf', [ManagerMonthlyReportController::class, 'downloadPdf'])->name('downloadPdf');
});

Route::group(['prefix' => 'weeklyReports', 'as' => 'weeklyReport.'], function () {
    Route::get('list', [SupervisorWeeklyReportController::class, 'index'])->name('List'); 
    Route::get('create', [SupervisorWeeklyReportController::class, 'create'])->name('create'); 
    Route::post('store', [SupervisorWeeklyReportController::class, 'store'])->name('store'); 
    Route::get('show/{id}', [SupervisorWeeklyReportController::class, 'show'])->name('show');
    Route::get('edit/{id}', [SupervisorWeeklyReportController::class, 'edit'])->name('edit'); 
    Route::put('update/{id}', [SupervisorWeeklyReportController::class, 'update'])->name('update'); 
    Route::delete('delete/{id}', [SupervisorWeeklyReportController::class, 'destroy'])->name('destroy'); 
    
      Route::get('download-pdf', [SupervisorWeeklyReportController::class, 'downloadPdf'])->name('downloadPdf');
});

Route::group(['prefix' => 'eventIncidents', 'as' => 'eventIncident.'], function () {
    Route::get('list', [EventIncidentController::class, 'index'])->name('List'); 
    Route::get('create', [EventIncidentController::class, 'create'])->name('create'); 
    Route::post('store', [EventIncidentController::class, 'store'])->name('store'); 
     Route::get('edit/{id}', [EventIncidentController::class, 'edit'])->name('edit'); 
     Route::get('show/{id}', [EventIncidentController::class, 'show'])->name('show');
    Route::put('update/{id}', [EventIncidentController::class, 'update'])->name('update'); 
   Route::delete('delete/{id}', [EventIncidentController::class, 'destroy'])->name('destroy'); 
   
   Route::get('download-pdf', [EventIncidentController::class, 'downloadPdf'])->name('downloadPdf');

});

Route::group(['prefix' => 'handovers', 'as' => 'handover.'], function () {
    Route::get('list', [CarHandoverController::class, 'index'])->name('List'); 
    Route::get('create', [CarHandoverController::class, 'create'])->name('create'); 
    Route::post('store', [CarHandoverController::class, 'store'])->name('store'); 
     Route::get('edit/{id}', [CarHandoverController::class, 'edit'])->name('edit'); 
     Route::get('show/{id}', [CarHandoverController::class, 'show'])->name('show');
    Route::put('update/{id}', [CarHandoverController::class, 'update'])->name('update'); 
   Route::delete('delete/{id}', [CarHandoverController::class, 'destroy'])->name('destroy'); 
   
   Route::get('download-pdf', [CarHandoverController::class, 'downloadPdf'])->name('downloadPdf');
});





Route::get('/dashboard', [DashboardController::class, 'index'])
    ->middleware(['auth', 'verified'])
    ->name('dashboard');


Route::middleware('auth')->group(function () {
    


Route::get('/', function () {
    $monthly = ManagerMonthlyReport::whereMonth('created_at', now()->month)->count();
    $weekly = SupervisorWeeklyReport::whereBetween('created_at', [now()->startOfWeek(), now()->endOfWeek()])->count();
    $incidents = EventIncident::whereMonth('created_at', now()->month)->count();

    $chartData = [
        'monthly' => $monthly,
        'weekly' => $weekly,
        'incidents' => $incidents,
    ];

    return view('welcome', compact('chartData'));
})->name('home');



    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
    Route::patch('/profile/update-photo', [ProfileController::class, 'updatePhoto'])->name('profile.update.photo');

    
});





Route::group(['prefix' => 'users', 'as' => 'user.'], function () {
    Route::get('list', [UserController::class, 'index'])->name('list'); 
    Route::get('create', [UserController::class, 'create'])->name('create'); 
    Route::post('store', [UserController::class, 'store'])->name('store'); 
    Route::get('edit/{user}', [UserController::class, 'edit'])->name('edit'); 
    Route::put('update/{user}', [UserController::class, 'update'])->name('update'); 
    Route::delete('delete/{user}', [UserController::class, 'destroy'])->name('delete'); 
});


Route::group(['prefix' => 'roles', 'as' => 'role.'], function () {
    Route::get('list', [RoleController::class, 'index'])->name('list'); 
    Route::get('create', [RoleController::class, 'create'])->name('create'); 
    Route::post('store', [RoleController::class, 'store'])->name('store'); 
    Route::get('edit/{role}', [RoleController::class, 'edit'])->name('edit'); 
    Route::put('update/{role}', [RoleController::class, 'update'])->name('update'); 
    Route::delete('delete/{role}', [RoleController::class, 'destroy'])->name('delete'); 
});


Route::get('/manager-report', [HomeController::class, 'managerReport'])->name('manager_report'); 
Route::get('/supervisor_reports', [HomeController::class, 'supervisorReport'])->name('supervisor_reports');
Route::get('/event_incidents', [HomeController::class, 'eventIncident'])->name('event_incidents');
Route::get('/car_handovers', [HomeController::class, 'carHandover'])->name('car_handovers');
Route::get('/setting', [HomeController::class, 'setting'])->name('setting');

Route::patch('/profile/update', [HomeController::class, 'update'])->name('profile.update');
Route::patch('/profile/update-password', [HomeController::class, 'updatePassword'])->name('profile.updatePassword');


Route::get('/reports_archive', [ReportsArchive::class, 'reportsArchive'])->name('reports_archive');




require __DIR__.'/auth.php';
