<!DOCTYPE html>
<html>
<head>
    <title>Car Handover List</title>
    <style>
        body { font-family: sans-serif; }
        table { width: 80%; border-collapse: collapse; font-size: 8px; }
        th, td { border: 1px solid #000; padding: 5px; text-align: left; }
          img { max-height: 60px; }
    </style>
</head>
<body>

<h2>Car Handover List</h2>

<table>
    <thead>
        <tr>
            <th>#</th>
            <th>Photo</th>
            <th>Plate Number</th>
            <th>Model</th>
            <th>Brand</th>
            <th>Mileage</th>
            <th>Location</th>
            <th>Delegated</th>
             <th>Delegation Info</th>
            <th>Receiver</th>
            <th>Supervisor</th>
            <th>Handover Date</th>
            <th>Handover Time</th>
              <th>Vehicle Contents</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $handovers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $handover): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td><?php echo e($key + 1); ?></td>
            <td>
                <?php if($handover->car_image): ?>
                    <img src="<?php echo e(public_path('car_images/' . $handover->car_image)); ?>" alt="Photo">
                <?php else: ?>
                    N/A
                <?php endif; ?>
            </td>
            <td><?php echo e($handover->plate_number); ?></td>
            <td><?php echo e($handover->model); ?></td>
            <td><?php echo e($handover->brand); ?></td>
            <td><?php echo e($handover->mileage); ?></td>
            <td><?php echo e($handover->location); ?></td>
            <td><?php echo e($handover->delegated ? 'Yes' : 'No'); ?></td>
            <td>
                <?php if($handover->delegated): ?>
                 Delegation Number :  <?php echo e($handover->delegation_number ?? 'N/A'); ?>

                <?php else: ?>
                   Reason For No Delegation : <?php echo e($handover->reason_for_no_delegation ?? 'N/A'); ?>

                <?php endif; ?>
            </td>
            
            <td><?php echo e($handover->receiver_name); ?></td>
            <td><?php echo e($handover->supervisor_name); ?></td>
            <td><?php echo e(\Carbon\Carbon::parse($handover->handover_date)->format('d M Y')); ?></td>
            <td><?php echo e(\Carbon\Carbon::parse($handover->handover_time)->format('h:i A')); ?></td>
            <td>
                <?php
                    $contents = is_string($handover->vehicleContents)
                        ? json_decode($handover->vehicleContents, true)
                        : $handover->vehicleContents;
                ?>
            
                <?php if(is_array($contents)): ?>
                    <ul style="margin: 0; padding-left: 15px;">
                        <?php $__currentLoopData = $contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e(is_array($item) ? json_encode($item) : $item); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                <?php else: ?>
                    N/A
                <?php endif; ?>
            </td>



    
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

</body>
</html>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/CarHandover/pdf.blade.php ENDPATH**/ ?>