<?php echo $__env->make('layouts.frontend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<!-- Welcome -->
<div class="container mt-4">
 <div class="d-flex flex-wrap align-items-center justify-content-center justify-content-md-start gap-3 mt-4 bg-dark text-white p-3 rounded">
    <img src="<?php echo e(asset('logos/logo.png')); ?>" alt="GFSP Logo" style="height: 60px; width: 300px;">
    <h1 class="welcome-text mb-0 fs-4 fs-md-3 fs-lg-2 ">Welcome to GFSP Security</h1>
</div>


  <!-- Visit Cards -->
  <div class="row mt-4 g-4">
    <div class="col-md-6">
      <div class="card p-4">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <h6 class="card-title mb-0">Monthly Visits <span class="pending">(Pending)</span></h6>
          <i class="bi bi-people icon-box"></i>
        </div>
        <h3><?php echo e($chartData['monthly']); ?></h3>
        <p class="text-muted mb-3">Manager project visits this month</p>
        <div class="input-group">
         
          <a href="<?php echo e(route('manager_report')); ?>" class="btn btn-outline-dark submit-btn">Submit Report</a>
        </div>
      </div>
    </div>

    <div class="col-md-6">
      <div class="card p-4">
        <div class="d-flex justify-content-between align-items-center mb-2">
          <h6 class="card-title mb-0">Weekly Visits <span class="pending">(Pending)</span></h6>
          <i class="bi bi-clock-history icon-box"></i>
        </div>
        <h3><?php echo e($chartData['weekly']); ?></h3>
        <p class="text-muted mb-3">Supervisor site visits this week</p>
        <div class="input-group">
       
          <a   href="<?php echo e(route('supervisor_reports')); ?>" class="btn btn-outline-dark submit-btn">Submit Report</a>
        </div>
      </div>
    </div>
  </div>

  <!-- Visits Overview + Monthly Reports -->
  <div class="row mt-4 g-4">
    <!-- Visits Overview -->
    <div class="col-md-6">
      <div class="card p-4 rounded-shadow">
        <h5 class="section-title"><i class="bi bi-eye"></i> Visits Overview</h5>
        <div class="bg-light p-3 rounded mt-3">
          <p class="mb-1 fw-semibold text-purple">Monthly Pending Visits Overview</p>
          <div class="d-flex align-items-center gap-3 mb-2">
            <i class="bi bi-calendar-event-fill text-primary fs-4"></i>
            <h4 class="mb-0 text-primary"><?php echo e($chartData['monthly'] + $chartData['weekly']); ?></h4>
          </div>
          <small class="text-muted">Total pending visits this month</small>
          <div class="progress mt-3" style="height: 6px;">
            <div class="progress-bar progress-bar-custom" role="progressbar" style="width: 80%"></div>
          </div>
        </div>
      </div>
    </div>

    <!-- Monthly Reports Chart -->
    <div class="col-md-6">
      <div class="card p-4 rounded-shadow">
        <h5 class="section-title"><i class="bi bi-bar-chart-line"></i> Monthly Reports</h5>
        <canvas id="reportsChart" height="200"></canvas>
      </div>
    </div>
  </div>
</div>

<script>
 const chartData = <?php echo json_encode($chartData, 15, 512) ?>;

  const ctx = document.getElementById('reportsChart').getContext('2d');
  new Chart(ctx, {
    type: 'bar',
    data: {
      labels: ['Monthly', 'Weekly', 'Incidents'],
      datasets: [{
        label: 'Reports',
        data: [chartData.monthly, chartData.weekly, chartData.incidents],
        backgroundColor: [
          'rgba(124, 66, 255, 0.8)',
          'rgba(54, 162, 235, 0.8)',
          'rgba(199, 121, 255, 0.8)'
        ],
        borderRadius: 10
      }]
    },
    options: {
      plugins: {
        legend: { display: false }
      },
      scales: {
        y: {
          beginAtZero: true,
          ticks: { stepSize: 4 }
        }
      }
    }
  });
</script>



<?php echo $__env->make('layouts.frontend.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/welcome.blade.php ENDPATH**/ ?>