<?php echo $__env->make('layouts.backend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="<?php echo e(route('dashboard')); ?>">
                        <i class="bi bi-house-door-fill"></i>
                    </a>
                </li>
                <li class="separator"><i class="bi bi-chevron-right"></i></li>
                <li class="nav-item">Edit Staff Evaluation</li>
            </ul>
        </div>

        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h4 class="card-title">Edit Staff Evaluation</h4>
                <a href="<?php echo e(route('monthlyReport.List')); ?>" class="btn btn-primary">Back to List</a>
            </div>

            <div class="card-body">
                <form action="<?php echo e(route('monthlyReport.update', $report->id)); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div id="staff-entries-container">
                        <?php $__currentLoopData = $report->staff_entries ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="form-section border rounded p-3 mb-3 position-relative bg-light">
                            <button type="button" class="btn-close position-absolute top-0 end-0 me-2 mt-2" onclick="this.closest('.form-section').remove()"></button>
                            <h6 class="mb-3">Staff Entry #<?php echo e($i + 1); ?></h6>
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">Staff Name</label>
                                    <input type="text" name="staff_entries[<?php echo e($i); ?>][name]" value="<?php echo e($entry['name'] ?? ''); ?>" class="form-control">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Shift</label>
                                    <input type="text" name="staff_entries[<?php echo e($i); ?>][shift]" value="<?php echo e($entry['shift'] ?? ''); ?>" class="form-control">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Attendance</label>
                                    <select name="staff_entries[<?php echo e($i); ?>][attendance]" class="form-select">
                                        <?php $__currentLoopData = ['Excellent', 'Good', 'Average', 'Poor']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(($entry['attendance'] ?? '') == $val ? 'selected' : ''); ?>><?php echo e($val); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Duties</label>
                                    <select name="staff_entries[<?php echo e($i); ?>][duties]" class="form-select">
                                        <?php $__currentLoopData = ['Excellent', 'Good', 'Average', 'Poor']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(($entry['duties'] ?? '') == $val ? 'selected' : ''); ?>><?php echo e($val); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Uniform</label>
                                    <select name="staff_entries[<?php echo e($i); ?>][uniform]" class="form-select">
                                        <?php $__currentLoopData = ['Excellent', 'Good', 'Average', 'Poor']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(($entry['uniform'] ?? '') == $val ? 'selected' : ''); ?>><?php echo e($val); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Presence</label>
                                    <select name="staff_entries[<?php echo e($i); ?>][presence]" class="form-select">
                                        <?php $__currentLoopData = ['Excellent', 'Good', 'Average', 'Poor']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php echo e(($entry['presence'] ?? '') == $val ? 'selected' : ''); ?>><?php echo e($val); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <button type="button" class="btn btn-outline-primary btn-sm mb-3" id="add-entry-btn">
                        <i class="bi bi-plus-circle"></i> Add Staff Entry
                    </button>

                    <div class="form-section mb-4">
                        <label class="form-label fw-semibold">Report Details</label>
                        <textarea class="form-control" name="description" rows="4"><?php echo e($report->description); ?></textarea>
                    </div>

                    <div class="form-section mb-4">
                        <label class="form-label fw-semibold">Photo Evidence</label>
                        <input type="file" name="photo" accept="image/*" class="form-control">
                        <?php if($report->photo): ?>
                            <img src="<?php echo e(asset('storage/' . $report->photo)); ?>" class="mt-2" width="100">
                        <?php endif; ?>
                    </div>

                    <div class="form-section mb-4">
                        <label class="form-label fw-semibold">Location <span class="text-danger">*</span></label>
                        <input type="text" name="location" value="<?php echo e($report->location); ?>" class="form-control" required>
                    </div>

                    <div class="d-flex justify-content-end mt-3">
                        <button type="submit" class="btn btn-success">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    let staffEntryCount = <?php echo e(count($report->staff_entries ?? [])); ?>;

    document.getElementById("add-entry-btn").addEventListener("click", function () {
        staffEntryCount++;
        const entryHTML = `
        <div class="form-section border rounded p-3 mb-3 position-relative bg-light">
            <button type="button" class="btn-close position-absolute top-0 end-0 me-2 mt-2" onclick="this.closest('.form-section').remove()"></button>
            <h6 class="mb-3">Staff Entry #${staffEntryCount}</h6>
            <div class="row g-3">
                <div class="col-md-6">
                    <label class="form-label">Staff Name</label>
                    <input type="text" name="staff_entries[${staffEntryCount}][name]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Shift</label>
                    <input type="text" name="staff_entries[${staffEntryCount}][shift]" class="form-control">
                </div>
                <div class="col-md-6">
                    <label class="form-label">Attendance</label>
                    <select name="staff_entries[${staffEntryCount}][attendance]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Duties</label>
                    <select name="staff_entries[${staffEntryCount}][duties]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Uniform</label>
                    <select name="staff_entries[${staffEntryCount}][uniform]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
                <div class="col-md-6">
                    <label class="form-label">Presence</label>
                    <select name="staff_entries[${staffEntryCount}][presence]" class="form-select">
                        <option selected disabled>Select rating</option>
                        <option>Excellent</option>
                        <option>Good</option>
                        <option>Average</option>
                        <option>Poor</option>
                    </select>
                </div>
            </div>
        </div>
        `;
        document.getElementById("staff-entries-container").insertAdjacentHTML("beforeend", entryHTML);
    });
</script>

<?php echo $__env->make('layouts.backend.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/ManagerMonthlyReport/edit.blade.php ENDPATH**/ ?>