<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Settings Page</title>
   <link rel="icon" href="<?php echo e(asset('logos/fiv.png')); ?>" type="image/x-icon"/>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
  <style>
    body {
      background-color: #F7FAFC;
      font-family: 'Segoe UI', sans-serif;
    }
    .card {
      border-radius: 16px;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
    }
    .card h5 {
      font-weight: 600;
    }
    .form-control,
    .btn,
    .form-select {
      border-radius: 12px;
    }
    .toggle-switch {
      display: flex;
      align-items: center;
      justify-content: space-between;
    }
    .settings-header {
      font-size: 1.5rem;
      font-weight: 700;
    }
    .navbar .bi {
      font-size: 20px;
      color: darkblue;
    }
  </style>
</head>
<body>


<!-- Navbar -->
<nav class="navbar bg-light shadow-sm px-3 p-3">
  <div class="container-fluid d-flex justify-content-between">
    <div class="d-flex gap-4 align-items-center">
     <a href="<?php echo e(route('manager_report')); ?>"> <i class="bi bi-file-earmark" data-bs-toggle="tooltip" title="Manager Reports"></i></a>
     <a href="<?php echo e(route('supervisor_reports')); ?>"><i class="bi bi-clipboard-check" data-bs-toggle="tooltip" title="Supervisor Reports"></i></a>
     <a href="<?php echo e(route('event_incidents')); ?>"><i class="bi bi-exclamation-triangle" data-bs-toggle="tooltip" title="Event Incidents"></i></a>
     <a href="<?php echo e(route('car_handovers')); ?>"><i class="bi bi-car-front" data-bs-toggle="tooltip" title="Car Handovers"></i></a>
     <a href="<?php echo e(route('reports_archive')); ?>"> <i class="bi bi-archive" data-bs-toggle="tooltip" title="Reports Archive"></i></a>
     <a href="<?php echo e(route('setting')); ?>"> <i class="bi bi-gear" data-bs-toggle="tooltip" title="Settings"></i></a>
    </div>
    <div class="d-flex gap-4 align-items-center">
         <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-outline-primary">Main Dashboard</a>
      <div class="dropdown">
          <a href="#" role="button" id="notificationDropdown" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="bi bi-bell" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Notifications"></i>
          </a>
        
          <ul class="dropdown-menu dropdown-menu-end shadow" aria-labelledby="notificationDropdown">
            <li class="dropdown-header"><i class="bi bi-bell" ></i>  <strong>Notifications</strong> </li>
            <li><hr class="dropdown-divider"></li>
        
            <!-- Dummy Notification 1 -->
            <li>
              <a class="dropdown-item" href="#">
                <strong>New login</strong> from unknown device<br>
                <small class="text-muted">2 minutes ago</small>
              </a>
            </li><hr class="dropdown-divider"></li>
        
            <!-- Dummy Notification 2 -->
            <li>
              <a class="dropdown-item" href="#">
                <strong>Server Alert:</strong> High CPU usage<br>
                <small class="text-muted">10 minutes ago</small>
              </a>
            </li>
          </ul>
        </div>
      <div class="dropdown">
          <a href="#" class="d-flex align-items-center text-dark text-decoration-none" id="profileDropdown" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="bi bi-person-circle fs-4 me-2" data-bs-toggle="tooltip" title="Profile"></i>
            <span><?php echo e(Auth::user()->name ?? ''); ?></span>
          </a>
          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="profileDropdown">
            <li><a class="dropdown-item" href="<?php echo e(route('setting')); ?>"><i class="bi bi-gear me-2"></i>Setting</a></li>
            <li><hr class="dropdown-divider"></li>
           
            <li>
             <?php if(auth()->guard()->check()): ?>
              <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                <i class="bi bi-box-arrow-right me-2"></i>Logout
              </a>
            
              <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                <?php echo csrf_field(); ?>
              </form>
                <?php endif; ?>
                <?php if(auth()->guard()->guest()): ?>
                <li><a class="dropdown-item" href="<?php echo e(route('login')); ?>"><i class="bi bi-box-arrow-in-right me-2"></i>login</a></li>
                <?php endif; ?>
            </li>
          </ul>
      </div>
    </div>
  </div>
</nav>

<div class="container py-5">
  <div class="mb-4">
    <a href="<?php echo e(route('home')); ?>" class="text-decoration-none text-dark "><i class="bi bi-arrow-left"></i> Back</a>
    <h2 class="settings-header mt-2">Settings</h2>
    <p class="text-muted">Manage your account settings and preferences</p>
  </div>

  <div class="row g-4">
    <!-- Language -->
    <div class="col-md-6">
      <div class="card p-4">
        <h5><i class="bi bi-globe2"></i> Language</h5>
        <p class="text-muted">Select your preferred language</p>
        <select class="form-select">
          <option selected>English</option>
          <option>العربية</option>
        </select>
      </div>
    </div>

    <!-- Notifications -->
    <div class="col-md-6">
      <div class="card p-4">
        <h5><i class="bi bi-bell"></i>  Notifications</h5>
        <p class="text-muted">Manage your notification preferences</p>
        <div class="form-check form-switch">
          <input class="form-check-input" type="checkbox" id="emailNotifications" checked>
          <label class="form-check-label" for="emailNotifications">Email Notifications</label>
        </div>
        <div class="form-check form-switch mt-2">
          <input class="form-check-input" type="checkbox" id="pushNotifications" checked>
          <label class="form-check-label" for="pushNotifications">Push Notifications</label>
        </div>
      </div>
    </div>

    <!-- Account -->
    

    <div class="col-md-6">
        <div class="card p-4">
            <h5><i class="bi bi-person-circle"></i> <?php echo e(__('Account')); ?></h5>
            <p class="text-muted"><?php echo e(__("Manage your account information and password")); ?></p>
             <?php if(session('status') === 'profile-updated'): ?>
                <p class="text-sm text-success mt-2"><?php echo e(__('Profile updated successfully.')); ?></p>
            <?php endif; ?>
            <form method="post" action="<?php echo e(route('profile.update')); ?>" enctype="multipart/form-data" class="mt-6 space-y-6">
            <?php echo csrf_field(); ?>
            <?php echo method_field('patch'); ?>

            
            <div class="text-center mb-3">
                <?php if(auth()->user()->image): ?>
                    <img src="<?php echo e(asset('public/profile_photos/' . auth()->user()->image)); ?>" alt="Profile Photo" class="rounded-circle" style="width: 100px; height: 100px;">
                <?php else: ?>
                    <div class="rounded-circle bg-light d-inline-block p-3" style="width: 100px; height: 100px;">
                        <i class="bi bi-camera" style="font-size: 2.5rem;"></i>
                    </div>
                <?php endif; ?>

                <div class="mt-2">
                    <input type="file" name="image" class="form-control form-control-sm" />
                    <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['class' => 'mt-2','messages' => $errors->get('image')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mt-2','messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('image'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
                </div>
            </div>

            
            <div class="mt-3">
                <label class="form-label"><?php echo e(__('Full Name')); ?></label>
                <input type="text" class="form-control mb-2" name="name" placeholder="Full Name" value="<?php echo e(old('name', $user->name)); ?>">
                <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['class' => 'mt-2','messages' => $errors->get('name')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mt-2','messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('name'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
            </div>

            
            <label class="form-label"><?php echo e(__('Email Address')); ?></label>
            <input type="email" class="form-control mb-2" name="email" placeholder="Email Address" value="<?php echo e(old('email', $user->email)); ?>">
            <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['class' => 'mt-2','messages' => $errors->get('email')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mt-2','messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('email'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>

            <?php if($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $user->hasVerifiedEmail()): ?>
                <div class="mt-2">
                    <p class="text-sm text-muted">
                        <?php echo e(__('Your email address is unverified.')); ?>

                        <button type="submit" form="send-verification" class="btn btn-link p-0 align-baseline">
                            <?php echo e(__('Click here to re-send the verification email.')); ?>

                        </button>
                    </p>
                    <?php if(session('status') === 'verification-link-sent'): ?>
                        <p class="mt-2 font-medium text-sm text-success">
                            <?php echo e(__('A new verification link has been sent to your email address.')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

            
            <label class="form-label"><?php echo e(__('Phone Number')); ?></label>
            <input type="text" class="form-control mb-3" name="mobile" placeholder="Phone Number" value="<?php echo e(old('mobile', $user->mobile ?? '')); ?>">

            
            <button class="btn btn-primary w-100 mb-2"><?php echo e(__('Update Profile')); ?></button>

           

             </form>
             
             
    <!-- Change Password Section -->
    <div class="row">
    <div class="col-md-12 mt-4">
        <div class="card p-4">
            <h5><i class="bi bi-lock-fill"></i> <?php echo e(__('Change Password')); ?></h5>
            <p class="text-muted"><?php echo e(__("Update your account password.")); ?></p>
            <?php if(session('password_status') === 'password-updated'): ?>
                    <p class="text-sm text-success  mt-2"><?php echo e(__('Password updated successfully.')); ?></p>
            <?php endif; ?>
    
            <button type="button" onclick="togglePasswordForm()" class="btn btn-outline-primary w-100 mb-3">
                <?php echo e(__('Change Password')); ?>

            </button>
    
            <form id="passwordForm" class="d-none" method="post" action="<?php echo e(route('profile.updatePassword')); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('patch'); ?>
    
                <div class="mb-3">
                    <label class="form-label"><?php echo e(__('New Password')); ?></label>
                    <input type="password" class="form-control" name="new_password" placeholder="New Password">
                    <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['class' => 'mt-2','messages' => $errors->get('new_password')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'mt-2','messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('new_password'))]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
                </div>
    
                <div class="mb-3">
                    <label class="form-label"><?php echo e(__('Confirm Password')); ?></label>
                    <input type="password" class="form-control" name="new_password_confirmation" placeholder="Confirm Password">
                </div>
    
                <button class="btn btn-success w-100"><?php echo e(__('Update Password')); ?></button>
    
                
            </form>
        </div>
    </div>
    </div>
    
    
  
        </div>
    </div>

    



    <!-- Help & Support -->
    <div class="col-md-6">
      <div class="card p-4 h-100">
        <h5><i class="bi bi-patch-question-fill"></i> Help & Support</h5>
        <p class="text-muted">Get help with using the application</p>
       
        <div class="row">
          <div class="col-md-6">
            <div class="card p-4">
              <h5>Contact Support</h5>
              <p class="text-muted">
                <i class="bi bi-telephone"></i>
                <a href="tel:+966548431829" class="text-decoration-none text-dark">+966 54 843 1829</a>
              </p>
              <p class="text-muted">
                <i class="bi bi-envelope-arrow-up"></i>
                <a href="mailto:marwan.s@gfsp.com.sa" class="text-decoration-none text-dark">marwan.s@gfsp.com.sa</a>
              </p>
            </div>
          </div>
        </div>



      </div>
    </div>
  </div>
</div>
<script>
  const tooltipTriggerList = document.querySelectorAll('[data-bs-toggle="tooltip"]');
  [...tooltipTriggerList].map(el => new bootstrap.Tooltip(el));
</script>
  <script>
        function togglePasswordForm() {
            document.getElementById('passwordForm').classList.toggle('d-none');
        }
    </script>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
</body>
</html>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/front/setting.blade.php ENDPATH**/ ?>