<?php echo $__env->make('layouts.backend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>



<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="<?php echo e(route('dashboard')); ?>">
                        <i class="bi bi-house-door-fill"></i>
                    </a>
                </li>
                <li class="separator"><i class="bi bi-chevron-right"></i></li>
                <li class="nav-item">Car Handover</li>
                <li class="separator"><i class="bi bi-chevron-right"></i></li>
                <li class="nav-item">Edit Car Handover</li>
            </ul>
        </div>

        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h4 class="card-title">Edit Car Handover</h4>
                <a href="<?php echo e(route('handover.List')); ?>" class="btn btn-primary">Back to List</a>
            </div>

            <div class="card-body">
                <?php if(session('success')): ?>
                    <div class="alert alert-success">
                        <?php echo e(session('success')); ?>

                    </div>
                <?php endif; ?>

                <?php if($errors->any()): ?>
                    <div class="alert alert-danger">
                        <ul>
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <form action="<?php echo e(route('handover.update', $handover->id)); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    
                    <div class="form-section mb-4">
                        <h5>New Vehicle Handover</h5>
                        <div class="row g-3">
                            <div class="col-md-4">
                                <label class="form-label">Plate Number</label>
                                <input type="text" name="plate_number" class="form-control" value="<?php echo e(old('plate_number', $handover->plate_number)); ?>" placeholder="Enter plate number">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Model</label>
                                <input type="text" name="model" class="form-control" value="<?php echo e(old('model', $handover->model)); ?>" placeholder="Enter car model">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Type</label>
                                <input type="text" name="type" class="form-control" value="<?php echo e(old('type', $handover->type)); ?>" placeholder="Enter vehicle type">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Brand</label>
                                <input type="text" name="brand" class="form-control" value="<?php echo e(old('brand', $handover->brand)); ?>" placeholder="Enter vehicle brand">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Mileage</label>
                                <input type="text" name="mileage" class="form-control" value="<?php echo e(old('mileage', $handover->mileage)); ?>" placeholder="Enter current mileage">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Location *</label>
                                <input type="text" name="location" class="form-control" value="<?php echo e(old('location', $handover->location)); ?>" placeholder="Enter current location">
                            </div>

                            <div class="col-md-4">
                                <label class="form-label">Delegated</label>
                                <div class="form-check form-switch">
                                    <input type="hidden" name="delegated" value="0"> <!-- Default off -->
                                    <input class="form-check-input" type="checkbox" id="delegatedSwitch" name="delegated" value="1" <?php echo e($handover->delegated ? 'checked' : ''); ?>>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="form-group" id="delegation_number_field" style="<?php echo e($handover->delegated ? 'display: block;' : 'display: none;'); ?>">
                                    <label>Delegation Number</label>
                                    <input type="text" name="delegation_number" class="form-control" value="<?php echo e(old('delegation_number', $handover->delegation_number)); ?>">
                                </div>
                                
                                <div class="form-group" id="reason_no_delegation_field" style="<?php echo e(!$handover->delegated ? 'display: block;' : 'display: none;'); ?>">
                                    <label>Reason for No Delegation</label>
                                    <input type="text" name="reason_no_delegation" class="form-control" value="<?php echo e(old('reason_no_delegation', $handover->reason_for_no_delegation)); ?>">
                                </div>
                            </div>

                        </div>
                    </div>

                    
                    <div class="form-section mb-4">
                        <h6>Vehicle Contents</h6>
                        <div class="row g-3">
                              <?php
                                $selectedContents = [];
                                $otherContent = '';
                            
                                foreach ($handover->vehicleContents as $item) {
                                    if (is_array($item) && isset($item['other'])) {
                                        $selectedContents[] = 'Other';
                                        $otherContent = $item['other'];
                                    } else {
                                        $selectedContents[] = $item;
                                    }
                                }
                            
                                $contents = ['spareTire' => 'Spare Tire', 'jackHandle' => 'Jack & Handle', 'safetyKit' => 'Safety Kit', 'fireExtinguisher' => 'Fire Extinguisher', 'dashCam' => 'Dash Cam', 'other' => 'Other'];
                            ?>

                          <?php $__currentLoopData = $contents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input"
                                           type="checkbox"
                                           id="<?php echo e($id); ?>"
                                           name="contents[]"
                                           value="<?php echo e($label); ?>"
                                           <?php echo e(in_array($label, $selectedContents) ? 'checked' : ''); ?>>
                                    <label class="form-check-label" for="<?php echo e($id); ?>"><?php echo e($label); ?></label>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                          <div class="col-md-8" id="otherContentField" style="<?php echo e(in_array('Other', $selectedContents) ? '' : 'display: none;'); ?>">
                                <label class="form-label">Specify Other Contents</label>
                                <input type="text" class="form-control" name="other_contents" placeholder="Please specify"
                                       value="<?php echo e(old('other_contents', $otherContent)); ?>">
                            </div>

                        </div>
                    </div>

                    
                    <div class="form-section mb-4">
                        <h6>Receiver Information</h6>
                        <div class="row g-3">
                            <div class="col-md-4">
                                <label class="form-label">Receiver Name</label>
                                <input type="text" name="receiver_name" class="form-control" value="<?php echo e(old('receiver_name', $handover->receiver_name)); ?>" placeholder="Enter receiver's name">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Receiver Phone</label>
                                <input type="text" name="receiver_phone" class="form-control" value="<?php echo e(old('receiver_phone', $handover->receiver_phone)); ?>" placeholder="Enter receiver's phone">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Receiver ID</label>
                                <input type="text" name="receiver_id" class="form-control" value="<?php echo e(old('receiver_id', $handover->receiver_id)); ?>" placeholder="Enter receiver's ID number">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Supervisor Name</label>
                                <input type="text" name="supervisor_name" class="form-control" value="<?php echo e(old('supervisor_name', $handover->supervisor_name)); ?>" placeholder="Enter supervisor's name">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Date</label>
                                <input type="date" name="handover_date" class="form-control" value="<?php echo e(old('handover_date', $handover->handover_date)); ?>">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Time</label>
                                <input type="time" name="handover_time" class="form-control" value="<?php echo e(old('handover_time', $handover->handover_time)); ?>">
                            </div>
                        </div>
                    </div>

                    
                    <div class="form-section mb-4">
                        <h6>Car Images</h6>
                        <p class="text-muted mb-2">Upload car photo</p>
                        <input type="file" name="car_image" id="photo-input" accept="image/*" capture="environment" style="display: none;">
                        <button type="button" class="btn btn-outline-primary" onclick="document.getElementById('photo-input').click();">
                            <i class="bi bi-image"></i> Car Photo
                        </button>
                    </div>

                    
                    <div class="d-flex justify-content-end gap-2">
                        <button type="submit" class="btn btn-primary">Save Changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script>
   
  document.addEventListener('DOMContentLoaded', function () {
    const otherCheckbox = document.querySelector('#other');
    const otherField = document.querySelector('#otherContentField');

    function toggleOtherField() {
        if (otherCheckbox.checked) {
            otherField.style.display = '';
        } else {
            otherField.style.display = 'none';
        }
    }

    otherCheckbox.addEventListener('change', toggleOtherField);
    toggleOtherField(); // initial load
});


</script>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        const delegatedSwitch = document.getElementById("delegatedSwitch");
        const delegationField = document.getElementById("delegation_number_field");
        const reasonField = document.getElementById("reason_no_delegation_field");
        
        // Toggle delegation fields
        delegatedSwitch.addEventListener('change', function () {
            if (this.checked) {
                delegationField.style.display = "block";
                reasonField.style.display = "none";
            } else {
                delegationField.style.display = "none";
                reasonField.style.display = "block";
            }
        });
        
        // Initialize state
        if (!delegatedSwitch.checked) {
            delegationField.style.display = "none";
            reasonField.style.display = "block";
        }
    });
</script>



<?php echo $__env->make('layouts.backend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/CarHandover/edit.blade.php ENDPATH**/ ?>