<!DOCTYPE html>
<html>
<head>
    <title>Weekly Report</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; font-size: 10px; }
        h2 { margin-bottom: 10px; }
        h4, h5 { margin: 8px 0; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th, td { border: 1px solid #000; padding: 5px; text-align: left; }
        th { background-color: #f2f2f2; }
        img { max-width: 60px; max-height: 60px; }
    </style>
</head>
<body>
    <h2>Weekly Report</h2>

    <?php $__currentLoopData = $weeklyReports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <h4><?php echo e($index + 1); ?>. Report Entry</h4>
        <table>
            <tr>
                <th style="width: 5%;">#</th>
                <td><?php echo e($index + 1); ?></td>
            </tr>
            <tr>
                <th>Photo</th>
                <td>
                    <?php if($report->photo && file_exists(public_path('storage/' . $report->photo))): ?>
                        <img src="<?php echo e(public_path('storage/' . $report->photo)); ?>" alt="Photo">
                    <?php else: ?>
                        No Photo
                    <?php endif; ?>
                </td>
            </tr>
            <tr>
                <th>Location</th>
                <td><?php echo e($report->location); ?></td>
            </tr>
            <tr>
                <th>Description</th>
                <td><?php echo e($report->description); ?></td>
            </tr>
            <tr>
                <th>Date & Time</th>
                <td><?php echo e(\Carbon\Carbon::parse($report->created_at)->format('d M Y, h:i A')); ?></td>
            </tr>
        </table>

        
        <h5><?php echo e($index + 1); ?>.1 Staff Assessment</h5>
        <table>
            <thead>
                <tr>
                    <th>Staff Name</th>
                    <th>Shift</th>
                    <th>Attendance</th>
                    <th>Duties</th>
                    <th>Uniform</th>
                    <th>Presence</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $staffEntries = is_string($report->staff_entries) ? json_decode($report->staff_entries, true) : $report->staff_entries;
                ?>
                <?php if(is_array($staffEntries)): ?>
                    <?php $__currentLoopData = $staffEntries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($entry['name'] ?? '-'); ?></td>
                            <td><?php echo e($entry['shift'] ?? '-'); ?></td>
                            <td><?php echo e($entry['attendance'] ?? '-'); ?></td>
                            <td><?php echo e($entry['duties'] ?? '-'); ?></td>
                            <td><?php echo e($entry['uniform'] ?? '-'); ?></td>
                            <td><?php echo e($entry['presence'] ?? '-'); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <tr><td colspan="6">No Staff Assessment Data</td></tr>
                <?php endif; ?>
            </tbody>
        </table>

        
        <h5><?php echo e($index + 1); ?>.2 Staff Evaluation</h5>
        <table>
            <thead>
                <tr>
                    <th>Staff Name</th>
                    <th>Behavior</th>
                    <th>Alertness</th>
                    <th>Response</th>
                    <th>Reporting</th>
                    <th>Remarks</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $staffEvaluations = is_string($report->staff_data) ? json_decode($report->staff_data, true) : $report->staff_data;
                ?>
                <?php if(is_array($staffEvaluations)): ?>
                    <?php $__currentLoopData = $staffEvaluations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $eval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($eval['name'] ?? '-'); ?></td>
                            <td><?php echo e($entry['shift'] ?? '-'); ?></td>
                            <td><?php echo e($entry['attendance'] ?? '-'); ?></td>
                            <td><?php echo e($entry['duties'] ?? '-'); ?></td>
                            <td><?php echo e($entry['uniform'] ?? '-'); ?></td>
                            <td><?php echo e($entry['presence'] ?? '-'); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    <tr><td colspan="6">No Staff Evaluation Data</td></tr>
                <?php endif; ?>
            </tbody>
        </table>
        <hr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</body>
</html>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/SupervisorWeeklyReport/pdf.blade.php ENDPATH**/ ?>