<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Settings Page</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
  <style>
    body {
      background-color: #f4f6f8;
      font-family: 'Segoe UI', sans-serif;
    }
    .card {
      border-radius: 16px;
      box-shadow: 0 0 10px rgba(0,0,0,0.05);
    }
    .card h5 {
      font-weight: 600;
    }
    .form-control,
    .btn,
    .form-select {
      border-radius: 12px;
    }
    .toggle-switch {
      display: flex;
      align-items: center;
      justify-content: space-between;
    }
    .settings-header {
      font-size: 1.5rem;
      font-weight: 700;
    }
    .navbar .bi {
      font-size: 25px;
    }
  </style>
</head>
<body>


<!-- Navbar -->
<nav class="navbar bg-light shadow-sm px-3 p-3">
  <div class="container-fluid d-flex justify-content-between">
    <div class="d-flex gap-4 align-items-center">
     <a href="<?php echo e(route('manager_report')); ?>"> <i class="bi bi-file-earmark" data-bs-toggle="tooltip" title="Manager Reports"></i></a>
     <a href="<?php echo e(route('supervisor_reports')); ?>"><i class="bi bi-clipboard-check" data-bs-toggle="tooltip" title="Supervisor Reports"></i></a>
     <a href="<?php echo e(route('event_incidents')); ?>"><i class="bi bi-exclamation-triangle" data-bs-toggle="tooltip" title="Event Incidents"></i></a>
     <a href="<?php echo e(route('car_handovers')); ?>"><i class="bi bi-car-front" data-bs-toggle="tooltip" title="Car Handovers"></i></a>
     <a href="<?php echo e(route('reports_archive')); ?>"> <i class="bi bi-archive" data-bs-toggle="tooltip" title="Reports Archive"></i></a>
     <a href="<?php echo e(route('setting')); ?>"> <i class="bi bi-gear" data-bs-toggle="tooltip" title="Settings"></i></a>
    </div>
    <div class="d-flex gap-4 align-items-center">
      <a href="#"> <i class="bi bi-bell" data-bs-toggle="tooltip" title="Notifications"></i></a>
      <div class="dropdown">
          <a href="#" class="d-flex align-items-center text-dark text-decoration-none" id="profileDropdown" data-bs-toggle="dropdown" aria-expanded="false">
            <i class="bi bi-person-circle fs-4 me-2" data-bs-toggle="tooltip" title="Profile"></i>
            <span><?php echo e(Auth::user()->name); ?></span>
          </a>
          <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="profileDropdown">
            <li><a class="dropdown-item" href="<?php echo e(route('setting')); ?>"><i class="bi bi-gear me-2"></i>Setting</a></li>
            <li><hr class="dropdown-divider"></li>
            <li>
              <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                <i class="bi bi-box-arrow-right me-2"></i>Logout
              </a>
              <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                <?php echo csrf_field(); ?>
              </form>
            </li>
          </ul>
      </div>
    </div>
  </div>
</nav>

<div class="container py-5">
  <div class="mb-4">
    <a href="#" class="text-decoration-none text-dark"><i class="bi bi-arrow-left"></i> Back</a>
    <h2 class="settings-header mt-2">Settings</h2>
    <p class="text-muted">Manage your account settings and preferences</p>
  </div>

  <div class="row g-4">
    <!-- Language -->
    <div class="col-md-6">
      <div class="card p-4">
        <h5><i class="bi bi-globe2"></i> Language</h5>
        <p class="text-muted">Select your preferred language</p>
        <select class="form-select">
          <option selected>English</option>
          <option>Hindi</option>
          <option>Spanish</option>
        </select>
      </div>
    </div>

    <!-- Notifications -->
    <div class="col-md-6">
      <div class="card p-4">
        <h5><i class="bi bi-bell"></i>  Notifications</h5>
        <p class="text-muted">Manage your notification preferences</p>
        <div class="form-check form-switch">
          <input class="form-check-input" type="checkbox" id="emailNotifications" checked>
          <label class="form-check-label" for="emailNotifications">Email Notifications</label>
        </div>
        <div class="form-check form-switch mt-2">
          <input class="form-check-input" type="checkbox" id="pushNotifications" checked>
          <label class="form-check-label" for="pushNotifications">Push Notifications</label>
        </div>
      </div>
    </div>

    <!-- Account -->
    <div class="col-md-6">
      <div class="card p-4">
        <h5><i class="bi bi-person-circle"></i> Account</h5>
        <p class="text-muted">Manage your account information and password</p>
        <div class="text-center mb-3">
          <div class="rounded-circle bg-light d-inline-block p-3" style="width: 100px; height: 100px;">
            <i class="bi bi-camera" style="font-size: 2.5rem;"></i>
          </div>
          <div class="mt-2">
            <button class="btn btn-outline-secondary btn-sm">Take Profile Photo</button>
          </div>
        </div>

        <div class="mt-3">
        <label class="form-label">Full Name </label>
        <input type="text" class="form-control mb-2" placeholder="Full Name">
        </div>

        <label class="form-label">Email Address </label>
        <input type="email" class="form-control mb-2" placeholder="Email Address">

        <label class="form-label">Phone Number </label>
        <input type="text" class="form-control mb-3" placeholder="Phone Number">

        
        <button class="btn btn-primary w-100 mb-2">Update Profile</button>
        <button class="btn btn-outline-secondary w-100">Change Password</button>
      </div>
    </div>

    <!-- Help & Support -->
    <div class="col-md-6">
      <div class="card p-4 h-100">
        <h5><i class="bi bi-patch-question-fill"></i> Help & Support</h5>
        <p class="text-muted">Get help with using the application</p>
       
        <div class="row">
          <div class="col-md-6">
            <div class="card p-4">
              <h5>Contact Support</h5>
              <p class="text-muted">
                <i class="bi bi-telephone"></i>
                <a href="tel:+966548431829" class="text-decoration-none text-dark">+966 54 843 1829</a>
              </p>
              <p class="text-muted">
                <i class="bi bi-envelope-arrow-up"></i>
                <a href="mailto:marwan.s@gfsp.com.sa" class="text-decoration-none text-dark">marwan.s@gfsp.com.sa</a>
              </p>
            </div>
          </div>
        </div>



      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
</body>
</html>
<?php /**PATH C:\xampp\htdocs\security\resources\views/front/setting.blade.php ENDPATH**/ ?>