<?php echo $__env->make('layouts.backend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="<?php echo e(route('dashboard')); ?>">
                       <i class="fa-solid fa-house"></i>
                    </a>
                </li>
                <li class="separator">
                   <i class="fa-solid fa-chevron-right"></i>
                </li>
                <li class="nav-item">
                    <a href="#">Edit SubPart</a>
                </li>
            </ul>
        </div>
        
        <div class="row">
            <div class="col-md-8 mx-auto">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Edit SubPart</h4>
                        <a href="<?php echo e(route('subpart.List')); ?>" class="btn btn-secondary">Back to SubPart List</a>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('subpart.update', $subpart->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            
                            <div class="mb-3">
                                <label for="part_id">Part</label>
                                <select name="part_id" id="part_id" class="form-control" required>
                                    <option value="">Select a Part</option>
                                    <?php $__currentLoopData = $parts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $part): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($part->id); ?>" <?php echo e($part->id == $subpart->part_id ? 'selected' : ''); ?>>
                                            <?php echo e($part->name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            
                            <div class="mb-3">
                                <label for="name" class="form-label">Name</label>
                                <input type="text" class="form-control" id="name" name="name" value="<?php echo e($subpart->name); ?>" required>
                            </div>
                            
                             <div class="mb-3">
                                <label for="color" class="form-label">Color (HEX Code)</label>
                                <input type="text" name="color" id="color" class="form-control" value="<?php echo e(old('color', $subpart->color)); ?>" required>
                            </div>
                            
                            <div class="mb-3">
                                <label for="link">Part Link</label>
                                <input type="url" name="link" class="form-control" id="link" value="<?php echo e($subpart->link); ?>">
                            </div>

                            <button type="submit" class="btn btn-primary">Update</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php echo $__env->make('layouts.backend.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/u306728840/domains/sntsur.online/public_html/Dashboard/resources/views/subpart/edit.blade.php ENDPATH**/ ?>