
<footer class="mt-3" >
    <div class="container-fluid  ">
    
        <div class="row ">
            <div class="col-md-12">
                <p class="text-center text-light p-2">rashgotechsolutions.com Copyright © 2025. All rights reserved.</p>
            </div>
        </div>
    </div>
    
</footer>



<?php
use App\Models\Colorbox;

$colorboxes = Colorbox::all(); // Get all colorboxes
$labels = $colorboxes->pluck('label')->toArray(); // Extract labels
$values = $colorboxes->pluck('value')->toArray(); // Extract values
$colors = $colorboxes->pluck('color')->toArray(); // Extract color values
$ids = $colorboxes->pluck('id')->toArray(); // Extract colorbox IDs
?>

<script>
 var piedata = <?php echo json_encode($values, 15, 512) ?>;  
 var labels = <?php echo json_encode($labels, 15, 512) ?>; 
 var backgroundColors = <?php echo json_encode($colors, 15, 512) ?>; 
 var colorboxIds = <?php echo json_encode($ids, 15, 512) ?>; 

const ctx = document.getElementById('pieChart').getContext('2d');
const pieChart = new Chart(ctx, {
    type: 'pie',
    data: {
        labels: labels, 
        datasets: [{
            data: piedata, 
            backgroundColor: backgroundColors, 
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: {
                position: 'top',
                labels: {
                    usePointStyle: true,
                    color: '#000000', 
                    generateLabels: function(chart) {
                        const original = Chart.overrides.pie.plugins.legend.labels.generateLabels;
                        const labels = original(chart);

                        labels.forEach(label => {
                            label.hidden = !chart.isDatasetVisible(0) || chart.getDatasetMeta(0).data[label.index].hidden;
                        });

                        return labels;
                    }
                },
                onClick: function(evt, legendItem, legend) {
                    const index = legendItem.index;
                    const chart = legend.chart;
                    const meta = chart.getDatasetMeta(0);

                    // Toggle the visibility of the dataset
                    meta.data[index].hidden = !meta.data[index].hidden;
                    chart.update();
                }
            },
            tooltip: {
                enabled: false 
            }
        }
    },
    plugins: [{
        id: 'centerLabels',
        afterDraw: function(chart) {
            const ctx = chart.ctx;
            chart.data.datasets.forEach((dataset, i) => {
                const meta = chart.getDatasetMeta(i);
                meta.data.forEach((element, index) => {
                    if (element.hidden) return; // Skip hidden segments

                    const label = chart.data.labels[index];
                    const position = element.tooltipPosition();

                    ctx.fillStyle = '#050505'; 
                    ctx.font = (window.innerWidth < 768) ? 'bold 10px Arial' : 'bold 16px Arial';
                    ctx.textAlign = 'center';
                    ctx.textBaseline = 'middle';
                    
                    ctx.fillText(label, position.x, position.y);
                });
            });
        }
    }]
});

// Handle click event on the pie chart
document.getElementById('pieChart').onclick = function(evt) {
    const activePoints = pieChart.getElementsAtEventForMode(evt, 'nearest', { intersect: true }, true);
    if (activePoints.length) {
        const index = activePoints[0].index;
        const colorboxId = colorboxIds[index];

        window.location.href = `sections?colorbox_id=${colorboxId}`;
    }
};

</script>

<script>
    // document.addEventListener("visibilitychange", function () {
    //     if (document.hidden) {
    //         // Send AJAX request to log out
    //         fetch("<?php echo e(route('logout')); ?>", {
    //             method: "POST",
    //             headers: {
    //                 "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>",
    //                 "Content-Type": "application/json"
    //             },
    //             credentials: "same-origin"
    //         }).then(response => {
    //             if (response.ok) {
    //                 window.location.href = "<?php echo e(route('login')); ?>"; // Redirect to login page
    //             }
    //         }).catch(error => console.error("Logout failed:", error));
    //     }
    // });
</script>


</body>
 <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4" crossorigin="anonymous"></script>
</html>
<?php /**PATH /home/u306728840/domains/sntsur.online/public_html/Dashboard/resources/views/layouts/frontend/footer.blade.php ENDPATH**/ ?>