<?php echo $__env->make('layouts.backend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                <li class="nav-home">
                    <a href="<?php echo e(route('dashboard')); ?>">
                        <i class="fa-solid fa-house"></i>
                    </a>
                </li>
                <li class="separator">
                    <i class="fa-solid fa-chevron-right"></i>
                </li>
                <li class="nav-item">
                    <a href="#">Weekly  Report</a>
                </li>
            </ul>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title"> Weekly Report</h4>
                         <div>
                            <a href="<?php echo e(route('weeklyReport.downloadPdf')); ?>" class="btn btn-dark">Download PDF</a> 
                            
                            <a href="<?php echo e(route('weeklyReport.create')); ?>" class="btn btn-primary">+ Add </a>
                          </div>
                    </div>

                    <?php if(session('success')): ?>
                        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                    <?php endif; ?>

                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="basic-datatables" class="display table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        
                                        <th>Date & Time </th>
                                        <th>Photo</th>
                                        <th>Location</th>
                                        <th>Description</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $weeklyReports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($index + 1); ?></td>
                                            
                                            <td><?php echo e($report->created_at->format('d M Y, h:i A')); ?></td>


                                            <td>
                                                <?php if($report->photo): ?>
                                                    <img src="<?php echo e(asset('storage/' . $report->photo)); ?>" width="60" height="60" class="rounded shadow-sm" />
                                                <?php else: ?>
                                                    <span class="text-muted">No Photo</span>
                                                <?php endif; ?>
                                            </td>

                                            <td><?php echo e($report->location); ?></td>
                                            <td><?php echo e(Str::limit($report->description, 40) ?? 'N/A'); ?></td>
                                           
                                            <td>
                                                <a href="<?php echo e(route('weeklyReport.show', $report->id)); ?>" class="btn btn-info btn-sm">Show</a>
                                                <a href="<?php echo e(route('weeklyReport.edit', $report->id)); ?>" class="btn btn-warning btn-sm">Edit</a>
                                                <form action="<?php echo e(route('weeklyReport.destroy', $report->id)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>  
</div>

<?php echo $__env->make('layouts.backend.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/SupervisorWeeklyReport/index.blade.php ENDPATH**/ ?>