<?php echo $__env->make('layouts.backend.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="container">
    <div class="page-inner">
        <div class="page-header">
            <ul class="breadcrumbs mb-3">
                  <li class="nav-home">
                  <a href="<?php echo e(route('dashboard')); ?>">
                   <i class="fa-solid fa-house"></i>
                  </a>
                </li>
                <li class="separator">
                 <i class="fa-solid fa-chevron-right"></i>
                </li>
                <li class="nav-item">
                    <a href="#">Edit User</a>
                </li>
            </ul>
        </div>

         <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title">Edit User</h4>
                         <a href="<?php echo e(route('user.list')); ?>" class="btn btn-primary">Back to List</a>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('user.update', $user->id)); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <div class="mb-3">
                                <label>Name</label>
                                <input type="text" name="name" class="form-control" value="<?php echo e($user->name); ?>" required>
                            </div>

                            <div class="mb-3">
                                <label>Email</label>
                                <input type="email" name="email" class="form-control" value="<?php echo e($user->email); ?>" required>
                            </div>

                            <div class="mb-3">
                                <label>Password (Leave blank to keep current)</label>
                                <input type="password" name="password" class="form-control">
                            </div>

                            <div class="mb-3">
                                <label>Role</label>
                                <select name="role" class="form-control">
                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($id); ?>" <?php echo e($user->roles->first()->id == $id ? 'selected' : ''); ?>>
                                            <?php echo e($name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            
                            <div class="mb-3">
                                <label for="image" class="form-label">Profile Photo</label>
                                <input type="file" class="form-control" id="image" name="image" accept="image/*" onchange="previewImage(event)">
                                
                                <!-- Show existing image -->
                                <?php if($user->image): ?>
                                    <img id="imagePreview" src="<?php echo e(asset('public/profile_photos/' . $user->image)); ?>" alt="Profile Image" class="mt-3 rounded" style="width: 150px; height: 150px; object-fit: cover;">
                                <?php else: ?>
                                    <img id="imagePreview" src="#" alt="Profile Preview" class="mt-3 rounded" style="display: none; width: 150px; height: 150px; object-fit: cover;">
                                <?php endif; ?>
                            </div>


                            <button type="submit" class="btn btn-primary">Update User</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    function previewImage(event) {
        var input = event.target;
        var reader = new FileReader();
        reader.onload = function () {
            var img = document.getElementById("imagePreview");
            img.src = reader.result;
            img.style.display = "block";
        };
        reader.readAsDataURL(input.files[0]);
    }
</script>

<?php echo $__env->make('layouts.backend.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home4/rupar1bz/public_html/gfsp_security/resources/views/user/edit.blade.php ENDPATH**/ ?>